import * as validation from "@jet/environment/json/validation";
import * as models from "../../../api/models";
import * as productPageUtil from "../product-page-util";
/**
 * Create a shelf for the product page's version history.
 *
 * @param videos An array of videos to present in this shelf.
 * @param shelfMetrics The product page shelf metrics.
 * @returns A video shelf.
 */
export function create(objectGraph, videos, shelfMetrics) {
    return validation.context("videoShelf", () => {
        if (!videos || videos.length === 0) {
            return null;
        }
        let shelf;
        if (productPageUtil.isShelfBased(objectGraph)) {
            shelf = new models.Shelf("productMediaItem");
            shelf.title = objectGraph.loc.string("ProductPage.Section.Videos.Title");
            shelf.items = videos.map((video) => {
                const productMediaItem = new models.ProductMediaItem();
                productMediaItem.video = video;
                return productMediaItem;
            });
        }
        else {
            shelf = new models.Shelf("framedVideo");
            shelf.title = objectGraph.loc.string("ProductPage.Section.Videos.Title");
            shelf.items = videos.map((video) => {
                return new models.FramedVideo(video, true, "text/plain", null, null, true);
            });
        }
        shelf.isHorizontal = true;
        shelfMetrics.addImpressionsToShelf(objectGraph, shelf, "videos");
        return shelf;
    });
}
//# sourceMappingURL=video-shelf.js.map