import * as validation from "@jet/environment/json/validation";
import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as productCapabilities from "../../content/product-capabilities";
import * as contentAttributes from "../../content/attributes";
import * as mediaPlatformAttributes from "../../../foundation/media/platform-attributes";
/**
 * Create a shelf of capabilities for the product page.
 *
 * @param data The raw data response for a product page JSON fetch.
 * @param isFreeProduct Whether the offer for the given product is free.
 * @param shelfMetrics The product page shelf metrics.
 * @returns A shelf of capabilities.
 */
export function create(objectGraph, data, isFreeProduct, shelfMetrics) {
    return validation.context("capabilitiesShelf", () => {
        if (serverData.isNullOrEmpty(data)) {
            return null;
        }
        const attributePlatform = contentAttributes.bestAttributePlatformFromData(objectGraph, data);
        const bundleId = mediaPlatformAttributes.platformAttributeAsString(data, attributePlatform, "bundleId");
        if (serverData.isNullOrEmpty(bundleId)) {
            return null;
        }
        const capabilities = productCapabilities.productCapabilitiesFromData(objectGraph, data, isFreeProduct);
        if (serverData.isNullOrEmpty(capabilities)) {
            return null;
        }
        const shelf = new models.Shelf("productCapability");
        shelf.title = objectGraph.loc.string("ProductPage.Section.Supports.Title");
        shelf.items = capabilities;
        shelf.mergeWhenFetched = true;
        shelf.batchGroup = "gameCenter";
        if (objectGraph.client.isVision && capabilities.length < 3) {
            shelf.presentationHints = { isLowDensity: true };
        }
        shelfMetrics.addImpressionsToShelf(objectGraph, shelf, "supports");
        return shelf;
    });
}
//# sourceMappingURL=capabilities-shelf.js.map