import * as validation from "@jet/environment/json/validation";
import * as models from "../../../api/models";
import { isDefinedNonNullNonEmpty } from "../../../foundation/json-parsing/server-data";
import * as productPageCommon from "../product-page-common";
/**
 * Create a shelf of bundle parents for the product page.
 *
 * @param productData The product data response for a product page JSON fetch.
 * @param dataContainer The raw data response for a product page JSON fetch.
 * @param shelfMetrics The product page shelf metrics.
 * @returns A shelf of bundle parents.
 */
export function create(objectGraph, productData, dataContainer, shelfMetrics) {
    if (!dataContainer) {
        return null;
    }
    return validation.context("bundleParentsShelf", () => {
        const numberOfParents = dataContainer.data.length;
        if (!numberOfParents) {
            return null;
        }
        const contentType = "smallLockup";
        const shelf = new models.Shelf(contentType);
        shelf.isHorizontal = true;
        shelf.title = objectGraph.loc.string("ProductPage.Section.IncludedInBundles.Title");
        const containerItems = productPageCommon.lockupsFromDataContainer(objectGraph, dataContainer, shelfMetrics, 1 /* content.ArtworkUseCase.LockupIconSmall */, contentType);
        if (containerItems.remainingItems.length === 0 && containerItems.items.length === 0) {
            return null;
        }
        shelf.items = containerItems.items;
        if (isDefinedNonNullNonEmpty(containerItems.remainingItems)) {
            const shelfToken = new productPageCommon.ProductPageShelfToken(productData.id, containerItems.remainingItems, shelf.title, false, undefined, contentType, "infer", null);
            shelfToken.isBundleShelf = true;
            shelf.url = productPageCommon.shelfContentUrl(objectGraph, shelfToken, shelfMetrics);
        }
        if (numberOfParents < 2 || objectGraph.client.isTV) {
            shelf.rowsPerColumn = 1;
        }
        else {
            shelf.rowsPerColumn = 2;
        }
        shelfMetrics.addImpressionsToShelf(objectGraph, shelf, "bundleParent");
        return shelf;
    });
}
//# sourceMappingURL=bundle-parents-shelf.js.map