import { isSome } from "@jet/environment";
import * as models from "../../../../api/models/index";
import * as serverData from "../../../../foundation/json-parsing/server-data";
import * as content from "../../../content/content";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    const combinedFileSize = content.combinedFileSizeFromData(objectGraph, data);
    if (isFirstPartyHideableApp ||
        serverData.isNull(combinedFileSize) ||
        serverData.isNull(combinedFileSize.fileSizeByDevice)) {
        return null;
    }
    const sizeString = objectGraph.loc.fileSize(combinedFileSize.fileSizeByDevice);
    const title = suppressTitle ? "" : objectGraph.loc.string("File.Size");
    let totalFileSize = combinedFileSize.fileSizeByDevice;
    let annotation;
    if (serverData.isDefinedNonNull(combinedFileSize.maxEssentialInstallSizeInBytes)) {
        const combinedBinaryAndEssentialSize = combinedFileSize.fileSizeByDevice + combinedFileSize.maxEssentialInstallSizeInBytes;
        const maxEssentialInstallSizeInBytesString = objectGraph.loc
            .string("Install.Size.String")
            .replace("{fileSize}", objectGraph.loc.fileSize(combinedBinaryAndEssentialSize));
        const sizeItem = new models.AnnotationItem(maxEssentialInstallSizeInBytesString);
        const summary = preprocessor.GAMES_TARGET
            ? objectGraph.loc.fileSize(combinedBinaryAndEssentialSize)
            : undefined;
        annotation = new models.Annotation(title, [sizeItem], summary);
    }
    else if (serverData.isDefinedNonNull(combinedFileSize.maxInstallSizeInBytes)) {
        const sizeListItems = [];
        const initialAppSizeItem = new models.AnnotationItem(sizeString, {
            heading: objectGraph.loc.string("Initial.App.Size"),
        });
        sizeListItems.push(initialAppSizeItem);
        const sizeStringInstall = objectGraph.loc
            .string("Install.Size.String")
            .replace("{fileSize}", objectGraph.loc.fileSize(combinedFileSize.maxInstallSizeInBytes));
        const maxInstallSizeInBytesItem = new models.AnnotationItem(sizeStringInstall, {
            heading: objectGraph.loc.string("Additional.Content.After.App.Install"),
        });
        sizeListItems.push(maxInstallSizeInBytesItem);
        totalFileSize = totalFileSize + combinedFileSize.maxInstallSizeInBytes;
        const summarySizeString = preprocessor.GAMES_TARGET
            ? objectGraph.loc.fileSize(totalFileSize)
            : objectGraph.loc
                .string("Install.Size.String")
                .replace("{fileSize}", objectGraph.loc.fileSize(totalFileSize));
        annotation = new models.Annotation(title, sizeListItems, summarySizeString);
    }
    else {
        const sizeItem = new models.AnnotationItem(sizeString);
        const summary = preprocessor.GAMES_TARGET ? sizeString : undefined;
        annotation = new models.Annotation(title, [sizeItem], summary);
    }
    if (objectGraph.client.isVision || preprocessor.GAMES_TARGET) {
        const fileSizeAndUnit = content.fileSizeAndUnitFromCombinedFileSize(objectGraph, combinedFileSize);
        if (isSome(fileSizeAndUnit)) {
            annotation.leadingText = fileSizeAndUnit.unit;
        }
    }
    return annotation;
}
//# sourceMappingURL=size-annotation.js.map