import * as models from "../../../../api/models/index";
import * as mediaAttributes from "../../../../foundation/media/attributes";
import { createArtworkForResource } from "../../../content/artwork/artwork";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    const usesLocationBackgroundMode = mediaAttributes.attributeAsBooleanOrFalse(data, "usesLocationBackgroundMode");
    if (!usesLocationBackgroundMode) {
        return null;
    }
    const locationTitle = suppressTitle ? "" : objectGraph.loc.string("InfoList.Location.Title");
    const locationDescription = objectGraph.loc.string("InfoList.Location.Description");
    const locationItem = new models.AnnotationItem(locationDescription);
    const annotation = new models.Annotation(locationTitle, [locationItem]);
    if (objectGraph.client.isVision || preprocessor.GAMES_TARGET) {
        annotation.leadingArtwork = createArtworkForResource(objectGraph, "systemimage://location.circle");
    }
    return annotation;
}
//# sourceMappingURL=location-annotation.js.map