import * as models from "../../../../api/models/index";
import * as serverData from "../../../../foundation/json-parsing/server-data";
import * as stringUtil from "../../../../foundation/util/string-util";
import * as contentAttributes from "../../../content/attributes";
import { primaryLanguageLocaleFromLocales } from "../../../content/content";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    var _a;
    const languageList = contentAttributes.contentAttributeAsArrayOrEmpty(objectGraph, data, "languageList");
    if (serverData.isNullOrEmpty(languageList)) {
        return null;
    }
    const languageCount = languageList.length;
    if (languageCount < 1) {
        return null;
    }
    let summaryString;
    let expandedString;
    switch (languageCount) {
        case 0:
            break;
        case 1:
            expandedString = languageList[0];
            if (preprocessor.GAMES_TARGET) {
                summaryString = expandedString;
            }
            break;
        case 2:
            expandedString = objectGraph.loc
                .string("InfoList.Two.Languages.Summary")
                .replace("{first}", languageList[0])
                .replace("{second}", languageList[1]);
            if (preprocessor.GAMES_TARGET) {
                summaryString = expandedString;
            }
            break;
        default:
            const additionalLanguagesCount = languageCount - 1;
            summaryString = objectGraph.loc
                .string("InfoList.More.Languages.Summary")
                .replace("{language}", languageList[0])
                .replace("{count}", objectGraph.loc.formattedCount(additionalLanguagesCount));
            expandedString =
                (_a = stringUtil.join(languageList, objectGraph.loc.string("Conjunction.Separator"))) !== null && _a !== void 0 ? _a : undefined;
            break;
    }
    if (!serverData.isDefinedNonNull(expandedString)) {
        return null;
    }
    const expandedItem = new models.AnnotationItem(expandedString);
    const title = suppressTitle ? "" : objectGraph.loc.string("Supported.Languages");
    const annotation = new models.Annotation(title, [expandedItem], summaryString);
    if (objectGraph.client.isVision || preprocessor.GAMES_TARGET) {
        const supportedLocales = contentAttributes.contentAttributeAsArrayOrEmpty(objectGraph, data, "supportedLocales");
        const primaryLocale = primaryLanguageLocaleFromLocales(objectGraph, supportedLocales);
        if (serverData.isDefinedNonNull(primaryLocale)) {
            annotation.leadingText = primaryLocale.tag;
        }
    }
    return annotation;
}
//# sourceMappingURL=languages-annotation.js.map