import * as serverData from "../../foundation/json-parsing/server-data";
import * as mediaDataStructure from "../../foundation/media/data-structure";
import * as content from "../content/content";
import * as productPage from "./product-page";
import * as shelfBasedProductPage from "./shelf-based/shelf-based-product-page";
import { Parameters } from "../../foundation/network/url-constants";
export function isShelfBased(objectGraph) {
    return (objectGraph.featureFlags.isEnabled("shelves_2_0_product") ||
        objectGraph.client.isiOS ||
        objectGraph.client.isTV ||
        objectGraph.client.isVision ||
        objectGraph.client.isWeb ||
        preprocessor.GAMES_TARGET);
}
export async function createProductPageFromResponse(objectGraph, response, options = {}, additionalPageRequirements = {}, referrerData = null, isForPreloading = false, isViewOnly = false) {
    const productData = mediaDataStructure.dataFromDataContainer(objectGraph, response);
    const supportsArcade = content.isArcadeSupported(objectGraph, productData);
    const shelfBasedPage = await shelfBasedProductPage.createProductPageFromResponse(objectGraph, response, options, additionalPageRequirements, referrerData, isViewOnly);
    // In SkyE for PPE we are calling directly into fetchPage and not fetchShelfBasedPage which expects a non-shelf-based
    // product page so in the preloading case we should return the non-shelf-based version
    // rdar://90971491 (Error: [object Object] is not expected type XD - JS fix)
    return isShelfBased(objectGraph) && !isForPreloading
        ? shelfBasedPage
        : productPage.createProductPageFromShelfBasedProductPage(objectGraph, shelfBasedPage, supportsArcade, options);
}
export function createProductPageSidePackFromResponse(objectGraph, response, options = {}) {
    if (!objectGraph.client.isSidepackingEnabled) {
        return null;
    }
    const supportsArcade = content.isArcadeSupported(objectGraph, response);
    const shelfBasedPage = shelfBasedProductPage.createProductPageSidePackFromResponse(objectGraph, response, options);
    return isShelfBased(objectGraph)
        ? shelfBasedPage
        : productPage.createProductPageFromShelfBasedProductPage(objectGraph, shelfBasedPage, supportsArcade, options);
}
export function badgesFromInfoRibbonShelf(objectGraph, shelf) {
    if (serverData.isNullOrEmpty(shelf === null || shelf === void 0 ? void 0 : shelf.items)) {
        return [];
    }
    if (isShelfBased(objectGraph)) {
        return shelf.items;
    }
    else {
        const informationRibbonItems = shelf.items;
        if (informationRibbonItems.length > 0) {
            return informationRibbonItems[0].badges;
        }
        else {
            return [];
        }
    }
}
/**
 * @param parameters The query params from a page request
 * @returns The app event id if it exists
 */
export function appEventIdFromParameters(parameters) {
    for (const [paramKey, paramValue] of Object.entries(parameters)) {
        if (paramKey.toLocaleLowerCase() === Parameters.appEventId.toLocaleLowerCase()) {
            return paramValue;
        }
    }
    return null;
}
//# sourceMappingURL=product-page-util.js.map