import * as models from "../../../api/models";
import * as contentAttributes from "../../content/attributes";
import { primaryLanguageLocaleFromLocales } from "../../content/content";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    const supportedLocales = contentAttributes.contentAttributeAsArrayOrEmpty(objectGraph, data, "supportedLocales");
    const primaryLocale = primaryLanguageLocaleFromLocales(objectGraph, supportedLocales);
    if (!primaryLocale) {
        return null;
    }
    const badgeContent = {
        paragraphText: primaryLocale.tag,
    };
    let caption;
    const additionalLanguagesCount = supportedLocales.length - 1;
    if (additionalLanguagesCount > 0) {
        caption = objectGraph.loc
            .stringWithCount("ProductPage.Badge.Language.Caption", additionalLanguagesCount)
            .replace("{number_other_languages}", objectGraph.loc.formattedCount(additionalLanguagesCount));
    }
    else {
        caption = primaryLocale.name;
    }
    const heading = objectGraph.loc.string("BADGE_LANGUAGE_HEADING");
    const badge = new models.Badge("paragraph", "languages", badgeContent, "standard", heading, caption, null, null, caption, "view");
    return badge;
}
//# sourceMappingURL=language-badge.js.map