import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../../foundation/media/attributes";
import * as mediaRelationship from "../../../foundation/media/relationships";
import { categoryArtworkData } from "../../categories";
import { makeDeveloperPageIntent } from "../../../api/intents/developer-page-intent";
import { getLocale } from "../../locale";
import * as artwork from "../../content/artwork/artwork";
import * as content from "../../content/content";
import * as metricsHelpersClicks from "../../metrics/helpers/clicks";
import * as badgesCommon from "./badges-common";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    const developer = mediaRelationship.relationshipData(objectGraph, data, "developer");
    const heading = objectGraph.loc.string("BADGE_DEVELOPER_HEADING");
    const caption = mediaAttributes.attributeAsString(data, "artistName");
    const style = objectGraph.client.isTV ? "annotation" : "standard";
    const badgeType = objectGraph.client.isTV ? "custom" : "artwork";
    const badge = new models.Badge(badgeType, "developer", {}, style, heading, caption, null, caption, heading, "infer");
    if (embeddedInRibbon && objectGraph.client.deviceType !== "tv") {
        const artworkData = categoryArtworkData(objectGraph, developer, true);
        // Artwork is required for artwork badges; if it's missing, default to a generic image
        if (badgeType === "artwork" && serverData.isNull(artworkData)) {
            if (objectGraph.client.isVision) {
                badge.artwork = artwork.createArtworkForResource(objectGraph, "systemimage://person.fill");
            }
            else {
                badge.artwork = artwork.createArtworkForResource(objectGraph, "systemimage://person.crop.square", 26, 26);
            }
        }
        else {
            badge.artwork = badgesCommon.badgeArtwork(objectGraph, artworkData);
        }
    }
    const url = content.developerUrlFromDeveloperData(objectGraph, developer);
    if (serverData.isDefinedNonNull(url)) {
        const action = new models.FlowAction("page");
        action.title = mediaAttributes.attributeAsString(data, "artistName");
        action.pageUrl = url;
        if (developer) {
            action.destination = makeDeveloperPageIntent({
                ...getLocale(objectGraph),
                id: developer.id,
            });
        }
        metricsHelpersClicks.addClickEventToAction(objectGraph, action, {
            targetType: "informationRibbon",
            id: developer.id,
            actionType: "navigate",
            pageInformation: metricsContext.pageInformation,
            locationTracker: metricsContext.locationTracker,
        });
        badge.clickAction = action;
    }
    return badge;
}
//# sourceMappingURL=developer-badge.js.map