import { isNothing, isSome } from "@jet/environment";
import * as models from "../../../api/models";
import * as mediaAttributes from "../../../foundation/media/attributes";
import * as ageRatings from "../../content/age-ratings";
import * as content from "../../content/content";
import { artworkTemplateForBundleImage, createArtworkForResource } from "../../content/artwork/artwork";
/**
 * Builds a `Badge` model representing the Apple content rating. Additionally
 * includes the Brazil age rating if user is in the BR storefront.
 */
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    var _a;
    return ((_a = createModernBadge(objectGraph, data, embeddedInRibbon, metricsContext)) !== null && _a !== void 0 ? _a : createLegacyBadge(objectGraph, data, embeddedInRibbon, metricsContext));
}
function createModernBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    const name = ageRatings.name(objectGraph, data);
    if (isNothing(name)) {
        return null;
    }
    let caption;
    let longCaption;
    if (preprocessor.GAMES_TARGET) {
        caption = undefined;
    }
    else if (embeddedInRibbon && !objectGraph.client.isVision) {
        if (ageRatings.hasInAppControls(objectGraph, data)) {
            caption = objectGraph.loc.string("ProductPage.Badge.AgeRating.Caption.Ribbon.InAppControls");
        }
        else {
            caption = objectGraph.loc.string("ProductPage.Badge.AgeRating.Caption.Ribbon");
        }
    }
    else {
        caption = objectGraph.loc.string("ProductPage.Badge.AgeRating.Caption");
    }
    const heading = preprocessor.GAMES_TARGET
        ? undefined
        : objectGraph.loc.string("ProductPage.Badge.AgeRating.Heading");
    const accessibilityCaption = objectGraph.loc.string("ProductPage.Badge.AgeRating.AX.Caption");
    const pictogramResource = ageRatings.pictogramResource(objectGraph, data);
    const badgeType = isSome(pictogramResource) ? "artwork" : "contentRating";
    const style = objectGraph.client.isTV ? "annotation" : "standard";
    const badge = new models.Badge(badgeType, "contentRating", { contentRating: name }, style, heading, caption, longCaption, name, accessibilityCaption, "view");
    if (isSome(pictogramResource)) {
        badge.isMonochrome = false;
        badge.artwork = createArtworkForResource(objectGraph, artworkTemplateForBundleImage(pictogramResource), 26, 26);
    }
    return badge;
}
function createLegacyBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    const contentRating = mediaAttributes.attributeAsString(data, "contentRatingsBySystem.appsApple.name");
    if (isNothing(contentRating)) {
        return null;
    }
    const badgeContent = { contentRating: contentRating };
    const brazilRank = mediaAttributes.attributeAsNumber(data, "contentRatingsBySystem.appsBrazil.rank");
    const contentRatingResource = content.storefrontContentRatingResourceForRank(objectGraph, brazilRank !== null && brazilRank !== void 0 ? brazilRank : undefined);
    if (contentRatingResource) {
        badgeContent.contentRatingResource = contentRatingResource;
    }
    let title;
    if (preprocessor.GAMES_TARGET) {
        title = undefined;
    }
    else if (embeddedInRibbon && !objectGraph.client.isVision) {
        title = objectGraph.loc.string("BADGE_AGE_RATING_YEARS");
    }
    else {
        title = objectGraph.loc.string("BADGE_AGE_RATING");
    }
    const heading = preprocessor.GAMES_TARGET ? undefined : objectGraph.loc.string("BADGE_AGE_RATING_HEADING");
    const accessibilityCaption = objectGraph.loc.string("PRODUCT_ACCESSIBILITY_BADGE_AGE_RATING_TITLE");
    const style = objectGraph.client.isTV ? "annotation" : "standard";
    return new models.Badge("contentRating", "contentRating", badgeContent, style, heading, title, undefined, contentRating, accessibilityCaption, "view");
}
//# sourceMappingURL=content-rating-badge.js.map