import * as validation from "@jet/environment/json/validation";
import * as mediaAttributes from "../../../foundation/media/attributes";
import * as category from "./category-badge";
import * as chart from "./chart-badge";
import * as compatibility from "./compatibility-badge";
import * as contentRating from "./content-rating-badge";
import * as controller from "./controller-badge";
import * as developer from "./developer-badge";
import * as editorsChoice from "./editors-choice-badge";
import * as friendsPlaying from "./friends-playing-badge";
import * as highMotion from "./high-motion-badge";
import * as language from "./language-badge";
import * as multiplayer from "./multiplayer-badge";
import * as preorder from "./preorder-badge";
import * as rating from "./rating-badge";
import * as size from "./size-badge";
import * as spatialController from "./spatial-controller-badge";
import * as storefrontContentRating from "./storefront-content-rating-badge";
const preorderBadgeList = [
    contentRating.createBadge,
    storefrontContentRating.createBadge,
    category.createBadge,
    multiplayer.createBadge,
    developer.createBadge,
    controller.createBadge,
    language.createBadge,
];
const standardBadgeList = [
    rating.createBadge,
    editorsChoice.createBadge,
    chart.createBadge,
    contentRating.createBadge,
    storefrontContentRating.createBadge,
];
const ribbonBadgeList = [
    rating.createBadge,
    contentRating.createBadge,
    storefrontContentRating.createBadge,
    controller.createHighPriorityBadge,
    friendsPlaying.createBadge,
    chart.createBadge,
    category.createBadge,
    multiplayer.createBadge,
    developer.createBadge,
    controller.createLowPriorityBadge,
    language.createBadge,
    size.createBadge,
];
const gamesBadgeList = [
    rating.createBadge,
    contentRating.createBadge,
    category.createBadge,
    controller.createBadge,
    developer.createBadge,
];
const visionRibbonBadgeList = [
    preorder.createBadge,
    compatibility.createBadge,
    rating.createBadge,
    spatialController.createRequiredBadge,
    controller.createHighPriorityBadge,
    spatialController.createHighPrioritySupportedBadge,
    editorsChoice.createBadge,
    contentRating.createBadge,
    storefrontContentRating.createBadge,
    highMotion.createBadge,
    category.createBadge,
    multiplayer.createBadge,
    controller.createLowPriorityBadge,
    spatialController.createLowPrioritySupportedBadge,
    developer.createBadge,
];
const visionPreorderBadgeList = [
    preorder.createBadge,
    compatibility.createBadge,
    editorsChoice.createBadge,
    category.createBadge,
    contentRating.createBadge,
    storefrontContentRating.createBadge,
    highMotion.createBadge,
    multiplayer.createBadge,
    controller.createBadge,
    spatialController.createBadge,
    developer.createBadge,
];
const tvBadgeList = [
    rating.createBadge,
    editorsChoice.createBadge,
    controller.createBadge,
    chart.createBadge,
    contentRating.createBadge,
    storefrontContentRating.createBadge,
    category.createBadge,
    multiplayer.createBadge,
    developer.createBadge,
];
function createBadges(objectGraph, badgeList, data, embeddedInRibbon, excludeCategoryIfChartExists, metricsContext) {
    const badges = [];
    for (const f of badgeList) {
        const badge = f(objectGraph, data, embeddedInRibbon, metricsContext);
        if (badge) {
            badges.push(badge);
        }
    }
    if (excludeCategoryIfChartExists && badges.some((badge) => badge.key === "chartPosition")) {
        // Category and chart badges are mutually exclusive, with chart taking priority
        const categoryIndex = badges.findIndex((badge) => badge.key === "category");
        if (categoryIndex >= 0) {
            badges.splice(categoryIndex, 1);
        }
    }
    return badges;
}
export function badgesFromResponse(objectGraph, data, embeddedInRibbon, metricsContext) {
    if (!data) {
        return [];
    }
    return validation.context("badgesFromLookupResponse", () => {
        let badgeList;
        let excludeCategoryIfChartExists = false;
        const isPreorder = mediaAttributes.attributeAsBooleanOrFalse(data, "isPreorder");
        if (preprocessor.GAMES_TARGET) {
            badgeList = gamesBadgeList;
        }
        else if (isPreorder) {
            if (objectGraph.client.isVision) {
                badgeList = visionPreorderBadgeList;
            }
            else {
                badgeList = preorderBadgeList;
            }
        }
        else if (objectGraph.client.isTV) {
            badgeList = tvBadgeList;
        }
        else if (objectGraph.client.isVision) {
            badgeList = visionRibbonBadgeList;
        }
        else if (embeddedInRibbon) {
            badgeList = ribbonBadgeList;
            const ribbonSupportedOnPlatform = objectGraph.host.isiOS || objectGraph.host.isMac || objectGraph.client.isWeb;
            if (ribbonSupportedOnPlatform && badgeList.indexOf(editorsChoice.createBadge) === -1) {
                badgeList.splice(1, 0, editorsChoice.createBadge);
            }
            excludeCategoryIfChartExists = true;
        }
        else {
            badgeList = standardBadgeList;
        }
        return createBadges(objectGraph, badgeList, data, embeddedInRibbon, excludeCategoryIfChartExists, metricsContext);
    });
}
//# sourceMappingURL=badges.js.map