import { isNothing } from "@jet/environment/types/optional";
import * as serverData from "../../foundation/json-parsing/server-data";
let suppressedPrivacyApps = null;
function initialize(objectGraph) {
    if (suppressedPrivacyApps !== null) {
        return;
    }
    suppressedPrivacyApps = new Set();
    for (const appId of objectGraph.bag.suppressedPrivacyAppIds) {
        suppressedPrivacyApps.add(appId);
    }
}
export function shouldSuppressPrivacyInformationForAdamId(objectGraph, adamId) {
    initialize(objectGraph);
    if (isNothing(suppressedPrivacyApps) || serverData.isNullOrEmpty(adamId)) {
        return false;
    }
    return suppressedPrivacyApps.has(adamId);
}
export function shouldSuppressPrivacyInformationForBundleId(objectGraph, bundleId) {
    initialize(objectGraph);
    if (isNothing(suppressedPrivacyApps) || serverData.isNullOrEmpty(bundleId)) {
        return false;
    }
    /// This handles a special case wildcard entry for macOS installers, to avoid the churn of adding new bundleIDs
    /// for each macOS release. We specifically do not want to treat all entries in `suppressedPrivacyApps` as a regex,
    /// as there is no expectation that any other entry will be a regex, and treating them as such may lead to false matches.
    if (suppressedPrivacyApps.has("com.apple.InstallAssistant.*") &&
        bundleId.startsWith("com.apple.InstallAssistant.")) {
        return true;
    }
    return suppressedPrivacyApps.has(bundleId);
}
//# sourceMappingURL=privacy-suppression.js.map