import * as mediaAttributes from "../../foundation/media/attributes";
/**
 * Use to obtain an clientIdentifier for an editorial context.
 * @param data The data from a media response
 * @return {ClientIdentifier} A client identifier that corresponds to the given editorial context.
 */
export function clientIdentifierForEditorialContextInData(objectGraph, data) {
    const rawEditorialContext = mediaAttributes.attributeAsString(data, "editorialContext");
    switch (rawEditorialContext) {
        case "Watch":
            return "com.apple.AppStore.BridgeStoreExtension" /* ClientIdentifier.AppStore_BridgeStoreExtension */;
        case "Messages":
            return "com.apple.MobileSMS" /* ClientIdentifier.MobileSMS */;
        case "RealityDevice":
            if (objectGraph.bag.enableDeviceDrivenDiscoveryContent) {
                return "VisionAppStore" /* ClientIdentifier.VisionAppStore */;
            }
            else {
                return null;
            }
        default:
            return null;
    }
}
//# sourceMappingURL=editorial-context.js.map