/**
 * Retrieve the active {@linkcode NormalizedLocale} for the client
 *
 * This can be useful in cases where you need to create a `RoutableIntent`
 * but do not have access to an existing `RoutableIntent` to read the locale
 * information off of.
 *
 * Note: this should be used only as a last resort. Wherever possible, prefer to
 * retrieve the {@linkcode NormalizedLocale} data off of an existing `RoutableIntent`
 * instead of depending on the global state in the {@linkcode AppStoreObjectGraph}.
 */
export function getLocale(objectGraph) {
    return {
        storefront: objectGraph.locale.activeStorefront,
        language: objectGraph.locale.activeLanguage,
    };
}
/**
 * Determine how the `NormalizedStorefront` should be encoded into a URL
 *
 * This provides a means by which the app can determine how the storefront and language
 * should be represented when creating a URL that includes locale information.
 *
 * This can be used, for example, to opt out of expressing an explicit language when it would
 * be the default for the given storefront.
 */
export function deriveLocaleForUrl(objectGraph, storefront) {
    return objectGraph.locale.deriveLocaleForUrl(storefront);
}
/**
 * Turns an {@linkcode UnnormalizedLocale} into a {@linkcode NormalizedLocale}
 */
export function normalizeLocale(objectGraph, unnormalizedLocale) {
    return objectGraph.locale.normalize(unnormalizedLocale);
}
//# sourceMappingURL=locale.js.map