/**
 * Created by ls on 12/15/18.
 *
 * A home for building application URL links for jumping to other applications.
 */
// region System Preference: Updates
/**
 * Build an URL that links to software update pref pane on given platform.
 * Optionally, supply an major OS version to signal Preferences to initiate download for given version if that is supported by the platform.
 * @param {DeviceType} deviceType Device type to request the update url for.
 * @param {string | null} majorOSBundle Optional major OS bundle identifier, e.g. com.apple.InstallAssistant.Catalina
 * @returns {string | null} URL that links into the "Software Updates" settings for given platform. `null` for platforms that we don't currently link into.
 * @note Currently, only MAS is supported by this function as it is the only platform linking to Preference > OS Update.
 */
export function osUpdateUrl(deviceType, majorOSBundle = null) {
    switch (deviceType) {
        case "mac":
            return macOSUpdateUrl(majorOSBundle);
        default:
            return null;
    }
}
/**
 * Build an URL that links to software update pref pane on macOS.
 * Optionally, supply an major OS version to signal Preferences to initiate download for given version.
 * @param {string | null} majorOSBundle Optional major OS bundle identifier, e.g. com.apple.InstallAssistant.Catalina
 * @returns {string | null} URL that links into the "Software Updates" settings for macOS.
 */
function macOSUpdateUrl(majorOSBundle) {
    /**
     * Workaround for <rdar://problem/47124330> Parsing and building URLs should follow unified spec
     * Manually build url.
     */
    // Preference URLs have no authority component.
    let updateUrl = `x-apple.systempreferences:com.apple.preferences.softwareupdate?client=AppStore&variant=CUSTOMER`;
    if (majorOSBundle) {
        updateUrl += `&installMajorOSBundle=${majorOSBundle}`;
    }
    return updateUrl;
}
// endregion
//# sourceMappingURL=os-update-links.js.map