import { isSome } from "@jet/environment";
import * as models from "../../api/models";
/// The number of shelves allowed in a single shelf batch.
const shelfBatchGroupMaxCount = 5;
/**
 * For a given generic page group the shelves in this page into batch groups
 * allowing us to separate our calls for incomplete shelves into groups based on where
 * the shelves are on the page. This will not muck with any pre-existing shelfBatchGroups
 *
 * @param page: The GenericPage to add shelf batches to.
 */
export function addBatchGroupsToPage(page) {
    let currentShelfBatchGroup = 0;
    let currentShelfBatchGroupCount = 0;
    for (const shelf of page.shelves) {
        if (isSome(shelf.batchGroup) && shelf.batchGroup.length > 0) {
            continue;
        }
        shelf.batchGroup = `${models.genericShelfBatchGroupBase}${currentShelfBatchGroup}`;
        currentShelfBatchGroupCount++;
        if (currentShelfBatchGroupCount === shelfBatchGroupMaxCount) {
            currentShelfBatchGroupCount = 0;
            currentShelfBatchGroup++;
        }
    }
}
//# sourceMappingURL=shelf-batching.js.map