import { isNothing } from "@jet/environment";
import * as mediaAttributes from "../../foundation/media/attributes";
export var EditorialShelfType;
(function (EditorialShelfType) {
    EditorialShelfType["ArcadeSeeAllGames"] = "editorial-shelves-arcade-see-all-games";
    EditorialShelfType["Collection"] = "editorial-shelves-collection";
    EditorialShelfType["Chart"] = "editorial-shelves-chart";
    EditorialShelfType["Tag"] = "editorial-shelves-tag";
    EditorialShelfType["Engagement"] = "editorial-shelves-engagement";
    EditorialShelfType["Text"] = "editorial-shelves-text";
    EditorialShelfType["Image"] = "editorial-shelves-image";
    EditorialShelfType["VideoClip"] = "editorial-shelves-video-clip";
    EditorialShelfType["Header"] = "editorial-shelves-header";
    EditorialShelfType["Recommendations"] = "editorial-shelves-recommendation";
    EditorialShelfType["GameCenter"] = "editorial-shelves-game-center";
    EditorialShelfType["Upsell"] = "editorial-shelves-upsell";
    EditorialShelfType["Marker"] = "editorial-shelves-marker";
})(EditorialShelfType || (EditorialShelfType = {}));
export var CollectionShelfDisplayStyle;
(function (CollectionShelfDisplayStyle) {
    CollectionShelfDisplayStyle["Hero"] = "Hero";
    CollectionShelfDisplayStyle["TextOnly"] = "TextOnly";
    CollectionShelfDisplayStyle["TextWithArtwork"] = "TextWithArtwork";
    CollectionShelfDisplayStyle["BrickSmall"] = "BrickSmall";
    CollectionShelfDisplayStyle["BrickMedium"] = "BrickMedium";
    CollectionShelfDisplayStyle["BrickLarge"] = "BrickLarge";
    CollectionShelfDisplayStyle["Charts"] = "Charts";
    CollectionShelfDisplayStyle["EditorialLockupHierarchicalPortrait"] = "EditorialLockupHierarchicalPortrait";
    CollectionShelfDisplayStyle["EditorialLockupHierarchicalRows"] = "EditorialLockupHierarchicalRows";
    CollectionShelfDisplayStyle["EditorialLockupMedium"] = "EditorialLockupMedium";
    CollectionShelfDisplayStyle["EditorialLockupMediumVariant"] = "EditorialLockupMediumVariant";
    CollectionShelfDisplayStyle["EditorialLockupLarge"] = "EditorialLockupLarge";
    CollectionShelfDisplayStyle["EditorialLockupLargeVariant"] = "EditorialLockupLargeVariant";
    CollectionShelfDisplayStyle["LockupMedium"] = "LockupMedium";
    CollectionShelfDisplayStyle["Lockup4Up"] = "Lockup4Up";
    CollectionShelfDisplayStyle["Poster"] = "Poster";
    CollectionShelfDisplayStyle["StorySmall"] = "StorySmall";
    CollectionShelfDisplayStyle["StoryMedium"] = "StoryMedium";
    CollectionShelfDisplayStyle["LockupSmall"] = "LockupSmall";
    CollectionShelfDisplayStyle["LockupLarge"] = "LockupLarge";
    CollectionShelfDisplayStyle["BreakoutLarge"] = "BreakoutLarge";
})(CollectionShelfDisplayStyle || (CollectionShelfDisplayStyle = {}));
/**
 * Returns the limit for a collection shelf to display in a non-See All page.
 * @param {CollectionShelfDisplayStyle} displayStyle Collection shelf display style.
 * @returns {number | undefined} Number of items to display.
 */
export function displayLimitForCollectionShelf(displayStyle, layoutDirection, shelfToken) {
    if (!preprocessor.GAMES_TARGET || shelfToken.isSeeAll) {
        return undefined;
    }
    switch (displayStyle) {
        case CollectionShelfDisplayStyle.EditorialLockupLarge:
            // "2 Cards" style https://quip-apple.com/qjjZAy4x977f
            return layoutDirection === "Condensed" ? 2 : undefined;
        case CollectionShelfDisplayStyle.EditorialLockupHierarchicalPortrait:
            // "3 Cards" style https://quip-apple.com/qjjZAy4x977f
            return 3;
        case CollectionShelfDisplayStyle.EditorialLockupMedium:
            // "4 Cards (4up)" style https://quip-apple.com/qjjZAy4x977f
            return layoutDirection === "Condensed" ? 4 : undefined;
        case CollectionShelfDisplayStyle.EditorialLockupHierarchicalRows:
            // "4 Cards (Hierarchical)" style https://quip-apple.com/qjjZAy4x977f
            return 4;
        case CollectionShelfDisplayStyle.Charts:
            // "4 Cards (Charts)" style https://quip-apple.com/qjjZAy4x977f
            return 6;
        case CollectionShelfDisplayStyle.LockupSmall:
            // "6 Rows" style https://quip-apple.com/qjjZAy4x977f
            return layoutDirection === "Condensed" ? 9 : undefined;
        default:
            return undefined;
    }
}
/**
 * Returns the display style override for See All pages.
 * @param {CollectionShelfDisplayStyle} displayStyle Collection shelf display style.
 * @returns {number | undefined} Number of items to display.
 */
export function collectionDisplayStyleOverride(displayStyle) {
    if (!preprocessor.GAMES_TARGET || isNothing(displayStyle)) {
        return null;
    }
    switch (displayStyle) {
        // These shelves should maintain their display style in See All pages.
        case CollectionShelfDisplayStyle.BrickSmall:
        case CollectionShelfDisplayStyle.LockupMedium:
            return displayStyle;
        // All other shelves will display in EditorialLockupLarge display style in See All pages.
        default:
            return CollectionShelfDisplayStyle.EditorialLockupLarge;
    }
}
export var MarkerShelfKind;
(function (MarkerShelfKind) {
    MarkerShelfKind["QuickLinks"] = "QuickLinks";
})(MarkerShelfKind || (MarkerShelfKind = {}));
export var CollectionShelfLayoutDirection;
(function (CollectionShelfLayoutDirection) {
    CollectionShelfLayoutDirection["Vertical"] = "Vertical";
    CollectionShelfLayoutDirection["Horizontal"] = "Horizontal";
    CollectionShelfLayoutDirection["Condensed"] = "Condensed";
})(CollectionShelfLayoutDirection || (CollectionShelfLayoutDirection = {}));
export function collectionShelfLayoutDirection(shelfToken) {
    const layoutDirection = mediaAttributes.attributeAsString(shelfToken.data, "layoutDirection");
    if (layoutDirection === CollectionShelfLayoutDirection.Horizontal) {
        return CollectionShelfLayoutDirection.Horizontal;
    }
    if (layoutDirection === CollectionShelfLayoutDirection.Condensed) {
        return CollectionShelfLayoutDirection.Condensed;
    }
    // Make default one as vertical for backward compatibility when code used to check `=== "Horizontal"`.
    return CollectionShelfLayoutDirection.Vertical;
}
export var CollectionShelfFilterOverride;
(function (CollectionShelfFilterOverride) {
    CollectionShelfFilterOverride["ShowInstalled"] = "ShowInstalled";
    CollectionShelfFilterOverride["ShowAllPlatforms"] = "ShowAllPlatforms";
    CollectionShelfFilterOverride["ShowOnlyPreorder"] = "ShowOnlyPreorder";
})(CollectionShelfFilterOverride || (CollectionShelfFilterOverride = {}));
export var GameCenterShelfClientFilter;
(function (GameCenterShelfClientFilter) {
    GameCenterShelfClientFilter["AllGames"] = "AllGames";
    GameCenterShelfClientFilter["ArcadeGames"] = "ArcadeGames";
})(GameCenterShelfClientFilter || (GameCenterShelfClientFilter = {}));
export var GameCenterShelfKind;
(function (GameCenterShelfKind) {
    GameCenterShelfKind["FriendsArePlaying"] = "FriendsArePlaying";
    GameCenterShelfKind["ContinuePlaying"] = "ContinuePlaying";
})(GameCenterShelfKind || (GameCenterShelfKind = {}));
export var UpsellShelfPlacement;
(function (UpsellShelfPlacement) {
    UpsellShelfPlacement["ArcadeTabHeader"] = "ArcadeTabHeader";
})(UpsellShelfPlacement || (UpsellShelfPlacement = {}));
export var UpsellShelfServiceType;
(function (UpsellShelfServiceType) {
    UpsellShelfServiceType["Arcade"] = "Arcade";
})(UpsellShelfServiceType || (UpsellShelfServiceType = {}));
//# sourceMappingURL=editorial-page-types.js.map