import * as models from "../../../api/models";
import { isNothing } from "@jet/environment";
import { makeShelfId } from "../../../gameservicesui/src/editorial-page/editorial-component-builder";
import * as mediaAPI from "@apple-media-services/media-api";
export function buildTextShelf(objectGraph, shelfToken) {
    if (!preprocessor.GAMES_TARGET) {
        return null;
    }
    const shelf = new models.Shelf("paragraph");
    shelf.id = makeShelfId(shelfToken).toString();
    const editorialCopy = mediaAPI.attributeAsString(shelfToken.data, "editorialCopy");
    if (isNothing(editorialCopy)) {
        return null;
    }
    const paragraph = new models.Paragraph(editorialCopy, "text/x-apple-as3-nqml", "article");
    shelf.items = [paragraph];
    return shelf;
}
//# sourceMappingURL=editorial-page-text-shelf-builder.js.map