import { isSome } from "@jet/environment/types/optional";
import * as models from "../../../../api/models";
import * as artworkBuilder from "../../../content/artwork/artwork";
import * as metricsHelpersClicks from "../../../metrics/helpers/clicks";
export function buildQuickLinksShelf(objectGraph, shelfToken) {
    if (objectGraph.user && objectGraph.user.isManagedAppleID) {
        return null;
    }
    // Watch App Store does not support titled button stacks,
    // and has different footer buttons.
    if (objectGraph.client.isWatch) {
        const shelf = new models.Shelf("action");
        const items = [];
        const accountFlowAction = new models.FlowAction("account");
        accountFlowAction.title = objectGraph.loc.string("ACCOUNT", "Account");
        accountFlowAction.artwork = artworkBuilder.createArtworkForResource(objectGraph, "systemimage://person.crop.circle");
        const accountFlowClickOptions = {
            targetType: "button",
            id: "account",
            pageInformation: shelfToken.metricsPageInformation,
            locationTracker: shelfToken.metricsLocationTracker,
        };
        metricsHelpersClicks.addClickEventToAction(objectGraph, accountFlowAction, accountFlowClickOptions);
        items.push(accountFlowAction);
        shelf.items = items;
        return shelf;
    }
    else {
        const items = [];
        if (isSome(objectGraph.bag.aboutAppStoreUrl)) {
            const aboutAppStoreAction = new models.ExternalUrlAction(objectGraph.bag.aboutAppStoreUrl);
            aboutAppStoreAction.title = objectGraph.loc.string("QuickLinks.AboutTheAppStore.Title");
            items.push(aboutAppStoreAction);
        }
        if (isSome(objectGraph.bag.aboutInAppPurchasesEditorialItemId)) {
            const aboutIAPsFlowAction = new models.FlowAction("article");
            aboutIAPsFlowAction.title = objectGraph.loc.string("QuickLinks.AboutInAppPurchases.Title");
            aboutIAPsFlowAction.pageUrl = `https://apps.apple.com/story/id${objectGraph.bag.aboutInAppPurchasesEditorialItemId}`;
            items.push(aboutIAPsFlowAction);
        }
        if (isSome(objectGraph.bag.reportProblemUrl)) {
            const reportProblemAction = new models.ExternalUrlAction(objectGraph.bag.reportProblemUrl);
            reportProblemAction.title = objectGraph.loc.string("REPORT_A_PROBLEM", "Report a Problem");
            items.push(reportProblemAction);
        }
        if (isSome(objectGraph.bag.requestARefundUrl)) {
            const requestRefundAction = new models.ExternalUrlAction(objectGraph.bag.requestARefundUrl);
            requestRefundAction.title = objectGraph.loc.string("QuickLinks.RequestARefund.Title");
            items.push(requestRefundAction);
        }
        if (isSome(objectGraph.bag.changePaymentMethodUrl)) {
            const changePaymentMethodAction = new models.ExternalUrlAction(objectGraph.bag.changePaymentMethodUrl);
            changePaymentMethodAction.title = objectGraph.loc.string("QuickLinks.ChangePaymentMethod.Title");
            items.push(changePaymentMethodAction);
        }
        if (isSome(objectGraph.bag.aboutFrenchAppStoreEditorialItemId)) {
            const aboutFrenchAppStoreFlowAction = new models.FlowAction("article");
            aboutFrenchAppStoreFlowAction.title = objectGraph.loc.string("QuickLinks.AboutFrenchAppStore.Title");
            aboutFrenchAppStoreFlowAction.pageUrl = `https://apps.apple.com/story/id${objectGraph.bag.aboutFrenchAppStoreEditorialItemId}`;
            items.push(aboutFrenchAppStoreFlowAction);
        }
        const shelf = new models.Shelf("action");
        shelf.title = objectGraph.loc.string("QuickLinks.Title");
        shelf.items = items;
        shelf.isHorizontal = true;
        shelf.rowsPerColumn = 1;
        shelfToken.metricsImpressionOptions.title = shelf.title;
        return shelf;
    }
}
//# sourceMappingURL=editorial-page-quick-links-marker-shelf-builder.js.map