import * as serverData from "../../../../foundation/json-parsing/server-data";
import { attributeAsString } from "../../../../foundation/media/attributes";
import { CollectionShelfDisplayStyle } from "../../editorial-page-types";
import { buildBreakoutLargeShelf } from "./editorial-page-breakout-large-collection-shelf-builder";
import { buildBrickLargeShelf, buildBrickMediumShelf, buildBrickSmallShelf, } from "./editorial-page-brick-collection-shelf-builder";
import { createShelfSeeAllActionIfNecessary } from "./editorial-page-collection-shelf-common";
import { buildHeroShelf } from "./editorial-page-hero-collection-shelf-builder";
import { buildEditorialLockupLargeShelf, buildEditorialLockupLargeVariantShelf, buildEditorialLockupMediumShelf, buildEditorialLockupMediumVariantShelf, buildLockupLargeShelf, buildLockupSmallShelf, buildEditorialLockupPosterShelf, buildEditorialLockupHierarchicalRows, buildEditorialLockupHierarchicalPortrait, buildLockupMedium, } from "./editorial-page-lockup-collection-shelf-builder";
import { buildMediumStoryCardShelf, buildSmallStoryCardShelf, } from "./editorial-page-story-card-collection-shelf-builder";
import { buildTextOnlyShelf } from "./editorial-page-text-only-collection-shelf-builder";
import { buildTextWithArtworkShelf } from "./editorial-page-text-with-artwork-collection-shelf-builder";
import { collectionShelfDisplayStyleFromShelfData } from "../../editorial-data-util";
import * as gamesHeroShelfBuilder from "../../../../gameservicesui/src/editorial-page/editorial-page-hero-collection-shelf-builder";
import { isSome } from "@jet/environment";
export function buildCollectionShelf(objectGraph, shelfToken) {
    let collectionDisplayStyle = attributeAsString(shelfToken.data, "displayStyle");
    if (preprocessor.GAMES_TARGET) {
        // A way to override display style as design wants to see large cards in "See all" rooms.
        const shelfTokenStyle = shelfToken.collectionDisplayStyle;
        if (isSome(shelfTokenStyle) && shelfTokenStyle !== collectionDisplayStyle) {
            collectionDisplayStyle = shelfToken.collectionDisplayStyle;
        }
    }
    if (serverData.isNullOrEmpty(collectionDisplayStyle)) {
        return null;
    }
    let shelf = null;
    switch (collectionDisplayStyle) {
        case CollectionShelfDisplayStyle.Hero:
            if (preprocessor.GAMES_TARGET) {
                shelf = gamesHeroShelfBuilder.buildHeroShelf(objectGraph, shelfToken);
            }
            else {
                shelf = buildHeroShelf(objectGraph, shelfToken);
            }
            break;
        case CollectionShelfDisplayStyle.TextOnly:
            shelf = buildTextOnlyShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.TextWithArtwork:
            shelf = buildTextWithArtworkShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.BrickSmall:
            shelf = buildBrickSmallShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.BrickMedium:
            shelf = buildBrickMediumShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.BrickLarge:
            shelf = buildBrickLargeShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.EditorialLockupHierarchicalPortrait:
            shelf = buildEditorialLockupHierarchicalPortrait(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.EditorialLockupHierarchicalRows:
            shelf = buildEditorialLockupHierarchicalRows(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.EditorialLockupMedium:
            shelf = buildEditorialLockupMediumShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.EditorialLockupMediumVariant:
            shelf = buildEditorialLockupMediumVariantShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.EditorialLockupLarge:
            shelf = buildEditorialLockupLargeShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.EditorialLockupLargeVariant:
            shelf = buildEditorialLockupLargeVariantShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.LockupMedium:
            shelf = buildLockupMedium(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.Poster:
            shelf = buildEditorialLockupPosterShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.StorySmall:
            shelf = buildSmallStoryCardShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.StoryMedium:
            shelf = buildMediumStoryCardShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.LockupSmall:
            shelf = buildLockupSmallShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.LockupLarge:
            shelf = buildLockupLargeShelf(objectGraph, shelfToken);
            break;
        case CollectionShelfDisplayStyle.BreakoutLarge:
            shelf = buildBreakoutLargeShelf(objectGraph, shelfToken);
            break;
        default:
            break;
    }
    if (serverData.isDefinedNonNullNonEmpty(shelf)) {
        shelf.seeAllAction = createShelfSeeAllActionIfNecessary(objectGraph, shelf, shelfToken);
        shelf.id = `shelf_${shelfToken.id}`;
    }
    return shelf;
}
/**
 * Decorates the input shelf metrics options with shelf specific fields.
 * @param objectGraph Current object graph
 * @param shelfMetricsOptions Base shelf metrics options
 * @returns Decorated shelf metrics options
 */
export function decorateCollectionShelfMetricsOptions(objectGraph, shelfData, shelfMetricsOptions) {
    const collectionDisplayStyle = collectionShelfDisplayStyleFromShelfData(objectGraph, shelfData);
    if (serverData.isNullOrEmpty(collectionDisplayStyle)) {
        return;
    }
    shelfMetricsOptions.displayStyle = collectionDisplayStyle;
}
//# sourceMappingURL=index.js.map