import * as models from "../../../../api/models";
import * as serverData from "../../../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../../../foundation/media/attributes";
import * as content from "../../../content/content";
import * as metricsHelpersLocation from "../../../metrics/helpers/location";
import { insertPlaceholdersIntoShelfIfRequired } from "../../../placeholders/placeholders";
import * as editorialActionUtil from "../../editorial-action-util";
import * as editorialDataUtil from "../../editorial-data-util";
import * as editorialCopyUtil from "../../editorial-page-editorial-copy-util";
import { CollectionShelfLayoutDirection } from "../../editorial-page-types";
import { createShelfTokenUrlIfNecessary, shouldDefer } from "./editorial-page-collection-shelf-common";
import * as gamesComponentBuilder from "../../../../gameservicesui/src/editorial-page/editorial-component-builder";
export function buildTextWithArtworkShelf(objectGraph, shelfToken) {
    var _a;
    const items = [];
    const shelf = new models.Shelf("action");
    shelf.isHorizontal =
        mediaAttributes.attributeAsString(shelfToken.data, "layoutDirection") ===
            CollectionShelfLayoutDirection.Horizontal;
    const shelfContents = editorialDataUtil.extractRemainingItemsOrInitialShelfContents(objectGraph, shelfToken);
    for (const itemData of shelfContents) {
        if (serverData.isNull(itemData.attributes) || shouldDefer(shelfToken)) {
            shelfToken.isDeferring = true;
            shelfToken.remainingItems.push(itemData);
            continue;
        }
        const action = editorialActionUtil.createPrimaryActionForComponentFromData(objectGraph, itemData, shelfToken);
        action.title = editorialCopyUtil.editorialTitleFromData(objectGraph, itemData, shelfToken.collectionDisplayStyle);
        let artwork;
        if (preprocessor.GAMES_TARGET) {
            const editorialArtwork = mediaAttributes.attributeAsDictionary(itemData, "editorialArtwork");
            artwork = serverData.asDictionary(editorialArtwork, "contentIconTrimmed");
        }
        else {
            artwork = mediaAttributes.attributeAsDictionary(itemData, "artwork");
        }
        if (serverData.isDefinedNonNullNonEmpty(artwork)) {
            action.artwork = content.artworkFromApiArtwork(objectGraph, artwork, {
                allowingTransparency: true,
                useCase: 20 /* content.ArtworkUseCase.CategoryIcon */,
            });
        }
        if (action.isValid()) {
            items.push(action);
            metricsHelpersLocation.nextPosition(shelfToken.metricsImpressionOptions.locationTracker);
        }
    }
    // We don't need this in our incomplete shelf URL, so we'll preemptively remove it.
    delete shelfToken.maxItemCount;
    shelf.eyebrow = shelfToken.eyebrow;
    shelf.eyebrowArtwork = shelfToken.eyebrowArtwork;
    shelf.title = shelfToken.title;
    shelf.subtitle = shelfToken.subtitle;
    if (preprocessor.GAMES_TARGET) {
        shelf.items = [gamesComponentBuilder.makeRibbonBar(objectGraph, items)];
        shelf.contentType = "ribbonBar";
    }
    else {
        shelf.items = items;
    }
    shelf.rowsPerColumn = (_a = mediaAttributes.attributeAsNumber(shelfToken.data, "rowCount")) !== null && _a !== void 0 ? _a : 1;
    shelf.url = createShelfTokenUrlIfNecessary(objectGraph, shelf, shelfToken);
    insertPlaceholdersIntoShelfIfRequired(objectGraph, shelf, shelfToken);
    return shelf;
}
//# sourceMappingURL=editorial-page-text-with-artwork-collection-shelf-builder.js.map