import { isNothing, isSome } from "@jet/environment";
import * as models from "../../../api/models";
import { attributeAsString } from "../../../foundation/media/attributes";
import { chartUrlFromData } from "../../content/content";
import { addClickEventToSeeAllAction } from "../../metrics/helpers/clicks";
import { insertPlaceholdersIntoShelfIfRequired } from "../../placeholders/placeholders";
import { CollectionShelfLayoutDirection } from "../editorial-page-types";
import { createShelfTokenUrlIfNecessary } from "./editorial-page-collection-shelf-builder/editorial-page-collection-shelf-common";
import { buildLockupChartShelf, buildLockupSmallShelf, } from "./editorial-page-collection-shelf-builder/editorial-page-lockup-collection-shelf-builder";
import { viewChartListActionWithGames } from "../../../gameservicesui/src/intent-controllers/page/charts-list-page-intent-controller";
import * as editorialDataUtil from "../editorial-data-util";
import { makeGamesFromCollection } from "../../../gameservicesui/src/models/cards/collection-card";
export function buildChartShelf(objectGraph, shelfToken) {
    var _a;
    shelfToken.showOrdinals = true;
    let shelf;
    if (preprocessor.GAMES_TARGET) {
        shelf = buildLockupChartShelf(objectGraph, shelfToken);
    }
    else {
        /// Currently the charts shelf doesn't return a `displayStyle`, we only support LockupSmall.
        shelf = buildLockupSmallShelf(objectGraph, shelfToken, false, CollectionShelfLayoutDirection.Horizontal);
    }
    if (isNothing(shelf)) {
        return undefined;
    }
    shelf.url = createShelfTokenUrlIfNecessary(objectGraph, shelf, shelfToken);
    insertPlaceholdersIntoShelfIfRequired(objectGraph, shelf, shelfToken);
    if (preprocessor.GAMES_TARGET) {
        if (isSome(shelf.header)) {
            shelf.header.titleAction = (_a = chartPageSeeAllActionForGames(objectGraph, shelfToken)) !== null && _a !== void 0 ? _a : undefined;
        }
        else {
            shelf.seeAllAction = chartPageSeeAllActionForGames(objectGraph, shelfToken);
        }
        shelf.id = `shelf_${shelfToken.id}`;
    }
    else {
        replaceShelfSeeAllAction(objectGraph, shelf, chartPageSeeAllAction(objectGraph, shelfToken));
    }
    return shelf;
}
function chartPageSeeAllActionForGames(objectGraph, shelfToken) {
    var _a;
    const gamesData = editorialDataUtil.extractRemainingItemsOrInitialShelfContents(objectGraph, shelfToken);
    const games = makeGamesFromCollection(objectGraph, gamesData, {}, {});
    const genre = attributeAsString(shelfToken.data, "genre");
    const chart = attributeAsString(shelfToken.data, "chart");
    if (isSome(games) && isSome(genre) && isSome(chart)) {
        const chartUrl = chartUrlFromData(objectGraph, genre, chart);
        return viewChartListActionWithGames(games, shelfToken.title, (_a = shelfToken.subtitle) !== null && _a !== void 0 ? _a : "", chartUrl, shelfToken.data.id, // TODO: provide real `reco_id` rdar://133659618 ([Play Now Feed] Use metrics.meta.reco_id from shelf meta in metrics)
        objectGraph);
    }
    return null;
}
function chartPageSeeAllAction(objectGraph, shelfToken) {
    const genre = attributeAsString(shelfToken.data, "genre");
    const chart = attributeAsString(shelfToken.data, "chart");
    const action = new models.FlowAction("page");
    action.pageUrl = chartUrlFromData(objectGraph, genre, chart);
    action.title = objectGraph.loc.string("ACTION_SEE_ALL");
    action.referrerUrl = shelfToken.metricsPageInformation.pageUrl;
    addClickEventToSeeAllAction(objectGraph, action, action.pageUrl, {
        pageInformation: shelfToken.metricsPageInformation,
        locationTracker: shelfToken.metricsLocationTracker,
    });
    return action;
}
/**
 * Update the shelf header to use the provided seeAll action.
 * @param objectGraph The App Store object graph used to check feature flags
 * @param shelfHeader  The shelf header to update
 * @param seeAllAction The "See All" action to apply
 */
export function replaceShelfHeaderSeeAllAction(objectGraph, shelfHeader, seeAllAction) {
    if (objectGraph.featureFlags.isEnabled("shelf_header")) {
        // Modern headers make title tappable with a chevron (>).
        shelfHeader.titleAction = seeAllAction;
    }
    else {
        // Legacy headers show "See All" textual button on trailing edge.
        shelfHeader.accessoryAction = seeAllAction;
    }
}
/**
 * Update the shelf header to use the provided seeAll action.
 * @param objectGraph The App Store object graph used to check feature flags
 * @param shelf  The shelf whose header needs updating
 * @param seeAllAction The see all action to apply
 */
export function replaceShelfSeeAllAction(objectGraph, shelf, seeAllAction) {
    if (objectGraph.featureFlags.isEnabled("shelf_header")) {
        if (isSome(shelf.header)) {
            replaceShelfHeaderSeeAllAction(objectGraph, shelf.header, seeAllAction);
        }
        else {
            shelf.header = {
                titleAction: seeAllAction,
            };
        }
    }
    else {
        shelf.seeAllAction = seeAllAction;
    }
}
//# sourceMappingURL=editorial-page-chart-shelf-builder.js.map