import * as serverData from "../../foundation/json-parsing/server-data";
import * as lockups from "../lockups/lockups";
import * as editorialDataUtil from "./editorial-data-util";
import * as editorialMediaUtil from "./editorial-media-util";
/**
 * Get the editorial artwork / video data for a component on an editorial page
 * @param objectGraph
 * @param data
 * @param collectionDisplayStyle
 */
export function editorialMediaDataFromData(objectGraph, data, collectionDisplayStyle) {
    switch (collectionDisplayStyle) {
        case "EditorialLockupMedium":
        case "EditorialLockupLarge":
        case "EditorialLockupMediumVariant":
        case "EditorialLockupLargeVariant":
            return editorialMediaUtil.editorialMediaDataForPlacement(objectGraph, data, editorialMediaUtil.EditorialMediaPlacement.EditorialLockup);
        case "BrickSmall":
        case "BrickMedium":
        case "BrickLarge":
            return editorialMediaUtil.editorialMediaDataForPlacement(objectGraph, data, editorialMediaUtil.EditorialMediaPlacement.Brick);
        case "StoryMedium":
        case "StorySmall":
            return editorialMediaUtil.editorialMediaDataForPlacement(objectGraph, data, editorialMediaUtil.EditorialMediaPlacement.StoryCard);
        case "Hero":
            return editorialMediaUtil.editorialMediaDataForPlacement(objectGraph, data, editorialMediaUtil.EditorialMediaPlacement.Hero);
        case "BreakoutLarge":
            return editorialMediaUtil.editorialMediaDataForPlacement(objectGraph, data, editorialMediaUtil.EditorialMediaPlacement.LargeBreakout);
        default:
            return {};
    }
}
/**
 * Get the app icons to display when there is no editorial artwork / video
 * @param objectGraph
 * @param data
 * @param lockupOptions
 */
export function editorialFallbackAppIconsFromData(objectGraph, data, lockupOptions) {
    const collectionLockups = editorialCollectionAppsFromData(objectGraph, data, { lockupOptions: lockupOptions });
    if (serverData.isNullOrEmpty(collectionLockups)) {
        return undefined;
    }
    return collectionLockups === null || collectionLockups === void 0 ? void 0 : collectionLockups.map((lockup) => {
        return lockup.icon;
    });
}
/**
 * Get lockup to be displayed on an editorial component
 * @param objectGraph
 * @param data
 * @param lockupOptions
 */
export function editorialAppLockupFromData(objectGraph, data, lockupOptions) {
    const productData = editorialDataUtil.extractProductData(objectGraph, data);
    if (serverData.isNullOrEmpty(productData)) {
        return null;
    }
    const appLockup = lockups.lockupFromData(objectGraph, productData, lockupOptions);
    return appLockup;
}
/**
 * Get the lockups from the collection this data is pointing to for a component on an editorial page
 * @param objectGraph
 * @param data
 * @param lockupOptions
 */
export function editorialCollectionAppsFromData(objectGraph, data, lockupOptions) {
    const collectionData = editorialDataUtil.extractCollectionData(objectGraph, data);
    if (serverData.isNullOrEmpty(collectionData)) {
        return null;
    }
    const collectionApps = lockups.lockupsFromData(objectGraph, collectionData, lockupOptions);
    return collectionApps;
}
//# sourceMappingURL=editorial-page-component-media-util.js.map