import { isFeatureEnabledForCurrentUser } from "../../common/util/lottery";
import * as serverData from "../../foundation/json-parsing/server-data";
import * as platformAttributes from "../../foundation/media/platform-attributes";
import * as contentAttributes from "./attributes";
export function isGameControllerSupported(objectGraph, data) {
    switch (controllerRequirementFromData(objectGraph, data)) {
        case "CONTROLLER_OPTIONAL":
        case "CONTROLLER_REQUIRED":
        case "SIRI_REMOTE_REQUIRED":
        case "SIRI_REMOTE_OR_CONTROLLER_REQUIRED":
        case "CONTROLLER_RECOMMENDED":
            return true;
        default:
            return false;
    }
}
export function isGameControllerRecommended(objectGraph, data) {
    return (objectGraph.client.isiOS &&
        isFeatureEnabledForCurrentUser(objectGraph, objectGraph.bag.gameControllerRecommendedRolloutRate) &&
        controllerRequirementFromData(objectGraph, data) === "CONTROLLER_RECOMMENDED");
}
export function isGameControllerRequired(objectGraph, data) {
    switch (controllerRequirementFromData(objectGraph, data)) {
        case "CONTROLLER_REQUIRED":
        case "SIRI_REMOTE_REQUIRED":
        case "SIRI_REMOTE_OR_CONTROLLER_REQUIRED":
            return true;
        default:
            return false;
    }
}
export function isSpatialControllerRequired(objectGraph, data) {
    return spatialControllerRequirementFromData(objectGraph, data) === "REQUIRED";
}
export function isSpatialControllerSupported(objectGraph, data) {
    return (spatialControllerRequirementFromData(objectGraph, data) === "SUPPORTED" ||
        spatialControllerRequirementFromData(objectGraph, data) === "REQUIRED");
}
export function controllerRequirementFromData(objectGraph, data) {
    // If the data does not contain the current device's OS, we need to use the best alternative that it is compatible with.
    const platformAttributeForClient = contentAttributes.defaultAttributePlatform(objectGraph);
    if (platformAttributeForClient === null) {
        return "NO_BADGE";
    }
    const requiresBinaryCompatibilityMode = !platformAttributes.hasPlatformAttribute(data, platformAttributeForClient);
    if (requiresBinaryCompatibilityMode) {
        const compatibilityControllerRequirementData = contentAttributes.contentAttributeAsDictionary(objectGraph, data, "compatibilityControllerRequirement");
        if (compatibilityControllerRequirementData === null ||
            serverData.isNullOrEmpty(compatibilityControllerRequirementData)) {
            return "NO_BADGE";
        }
        const compatibilityControllerRequirement = compatibilityControllerRequirementData[platformAttributeForClient];
        if (serverData.isNullOrEmpty(compatibilityControllerRequirement)) {
            return "NO_BADGE";
        }
        return compatibilityControllerRequirement;
    }
    const remoteControllerRequirement = contentAttributes.contentAttributeAsString(objectGraph, data, "remoteControllerRequirement");
    if (serverData.isDefinedNonNullNonEmpty(remoteControllerRequirement)) {
        return remoteControllerRequirement;
    }
    return "NO_BADGE";
}
export function spatialControllerRequirementFromData(objectGraph, data) {
    const platformAttributeForClient = contentAttributes.defaultAttributePlatform(objectGraph);
    if (!objectGraph.client.isVision ||
        platformAttributeForClient === null ||
        !objectGraph.featureFlags.isEnabled("spatial_controllers_2025A")) {
        return "NOT_SUPPORTED";
    }
    const spatialRequirement = platformAttributes.platformAttributeAsString(data, platformAttributeForClient, "spatialControllerRequirement");
    if (serverData.isDefinedNonNullNonEmpty(spatialRequirement)) {
        return spatialRequirement;
    }
    return "NOT_SUPPORTED";
}
//# sourceMappingURL=game-controller.js.map