import { isSome } from "@jet/environment/types/optional";
import * as derivedData from "../../foundation/json-parsing/derived-data";
import * as serverData from "../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../foundation/media/attributes";
import * as mediaRelationship from "../../foundation/media/relationships";
export function dataHasDeviceFamily(objectGraph, data, deviceFamily, recurse = false) {
    return derivedData.value(data, `dataHasDeviceFamily.${deviceFamily}`, () => {
        if (!data || !deviceFamily) {
            return false;
        }
        const deviceFamilies = deviceFamiliesFromData(objectGraph, data, recurse);
        return deviceFamilies.indexOf(deviceFamily) !== -1;
    });
}
export function dataOnlyHasDeviceFamily(objectGraph, data, deviceFamily, recurse = false) {
    var _a;
    return (((_a = dataHasDeviceFamily(objectGraph, data, deviceFamily, recurse)) !== null && _a !== void 0 ? _a : false) &&
        deviceFamiliesFromData(objectGraph, data, recurse).length === 1);
}
export function dataHasAnyDeviceFamilies(objectGraph, data, deviceFamilies, recurse = false) {
    const dataDeviceFamilies = new Set(deviceFamiliesFromData(objectGraph, data, recurse));
    for (const deviceFamily of deviceFamilies) {
        if (dataDeviceFamilies.has(deviceFamily)) {
            return true;
        }
    }
    return false;
}
export function dataOnlyHasDeviceFamilies(objectGraph, data, deviceFamilies, recurse = false) {
    const dataDeviceFamilies = new Set(deviceFamiliesFromData(objectGraph, data, recurse));
    // Ensure length matches
    if (deviceFamilies.length !== dataDeviceFamilies.size) {
        return false;
    }
    // Ensure content matches
    return deviceFamilies.every((deviceFamily) => dataDeviceFamilies.has(deviceFamily));
}
export function deviceFamiliesFromData(objectGraph, data, recurse = false) {
    const deviceFamilies = mediaAttributes.attributeAsArrayOrEmpty(data, "deviceFamilies");
    // If there isn't a device families attribute...
    if (deviceFamilies.length === 0 && recurse) {
        // Use its related apps (if it has them)
        const apps = mediaRelationship.relationshipCollection(data, "apps");
        if (isSome(apps)) {
            for (const app of apps) {
                // Get the device families from the first app that has one (if any)
                const appDeviceFamilies = deviceFamiliesFromData(objectGraph, app, recurse);
                if (serverData.isDefinedNonNullNonEmpty(appDeviceFamilies)) {
                    return appDeviceFamilies;
                }
            }
        }
    }
    return deviceFamilies;
}
/**
 * Returns the DeviceFamily for a given device type and model
 * @param {base.DeviceType} deviceType The device type to check
 * @param {objectGraph.host.deviceModel} deviceModel The device model to check, currently used to identify iPods
 * @returns {DeviceFamily} DeviceFamily associated with the input parameters
 */
export function deviceFamilyFromDeviceType(objectGraph, deviceType, deviceModel) {
    let deviceFamily = null;
    switch (deviceType) {
        case "phone":
            deviceFamily = "iphone";
            break;
        case "pad":
            deviceFamily = "ipad";
            break;
        case "mac":
            deviceFamily = "mac";
            break;
        case "tv":
            deviceFamily = "tvos";
            break;
        case "watch":
            deviceFamily = "watch";
            break;
        case "vision":
            deviceFamily = "realityDevice";
            break;
        default:
            break;
    }
    if (serverData.isDefinedNonNull(deviceModel) && deviceModel === "ipod") {
        deviceFamily = "ipod";
    }
    return deviceFamily;
}
//# sourceMappingURL=device-family.js.map