import * as modelsBase from "../../../api/models/base";
export function createArtworkVariantForClient(objectGraph, allowingTransparency = false, supportsWideGamut = false, useCase = 0 /* content.ArtworkUseCase.Default */) {
    const format = artworkFormatForClient(objectGraph, allowingTransparency);
    return createArtworkVariantForFormat(objectGraph, format, supportsWideGamut, useCase);
}
export function createArtworkVariantForFormat(objectGraph, format, supportsWideGamut = false, useCase = 0 /* content.ArtworkUseCase.Default */) {
    const quality = qualityForClient(objectGraph, format, useCase);
    return new modelsBase.ArtworkVariant(format, quality, supportsWideGamut);
}
export function createArtworkForResource(objectGraph, resource, width = 0, height = 0, backgroundColor = null, textColor = null, checksum = null) {
    const artwork = new modelsBase.Artwork(resource, width, height, [
        createArtworkVariantForClient(objectGraph, false, false, 0 /* content.ArtworkUseCase.Default */),
    ]);
    artwork.backgroundColor = backgroundColor;
    artwork.textColor = textColor;
    artwork.checksum = checksum;
    return artwork;
}
/**
 * Create a bundle artwork template for a resource.
 */
export function artworkTemplateForBundleImage(resource) {
    if (preprocessor.GAMES_TARGET) {
        return `bundleimage://${resource}?bundleid=com.apple.GameStoreKit`;
    }
    else {
        return `resource://${resource}`;
    }
}
/**
 * Create Artwork for a system image.
 */
export function createArtworkForSystemImage(objectGraph, resource) {
    return createArtworkForResource(objectGraph, `systemimage://${resource}`);
}
function artworkFormatForClient(objectGraph, allowsTransparency) {
    // Determine whether HEIF is supported for the given target.
    let supportsHEIF;
    switch (objectGraph.host.clientIdentifier) {
        case "com.apple.TVAppStore.AppStoreTopShelfExtension":
        case "com.apple.Arcade.ArcadeTopShelfExtension":
        case "com.apple.AppStore.Widgets":
            // Disable HEIF for top shelf
            supportsHEIF = false;
            break;
        default:
            supportsHEIF = objectGraph.client.supportsHEIF;
            break;
    }
    // HEIF is the image format, HEIC is the container
    const defaultArtworkFormat = supportsHEIF ? "heic" : "jpeg";
    const defaultArtworkFormatAllowingTransparency = supportsHEIF ? "heic" : "png";
    return allowsTransparency ? defaultArtworkFormatAllowingTransparency : defaultArtworkFormat;
}
function qualityForClient(objectGraph, artworkFormat, useCase) {
    switch (artworkFormat) {
        case "heic": {
            if (objectGraph.client.isTV && useCase === 21 /* content.ArtworkUseCase.Uber */) {
                return 70;
            }
            else {
                return 60;
            }
        }
        // JPEG, LCR and PNG
        default: {
            return 70;
        }
    }
}
//# sourceMappingURL=artwork.js.map