import { ChartsHubChart, ChartsHubPage, FlowAction } from "../../api/models";
import { makeChartsPageIntent } from "../../api/intents/charts-page-intent";
import { makeChartsPageURL } from "./charts-page-url";
import { getLocale } from "../locale";
import { getPlatform } from "../preview-platform";
function seeAllActionForChart(objectGraph, chart) {
    const selectedChart = chart.segments[chart.initialSegmentIndex].chart;
    const seeAllAction = new FlowAction("topCharts");
    const destinationIntent = makeChartsPageIntent({
        ...getLocale(objectGraph),
        ...getPlatform(objectGraph),
        genreId: chart.genreId,
        chart: selectedChart,
    });
    seeAllAction.destination = destinationIntent;
    seeAllAction.pageUrl = makeChartsPageURL(objectGraph, destinationIntent);
    return seeAllAction;
}
/**
 * Create a {@linkcode TopChart} from a {@linkcode TopChartsPage} without any of the
 * page-level properties defined
 */
function topChartFromPage(objectGraph, page, title) {
    const chart = new ChartsHubChart(page.genreId, page.ageBandId, title, page.segments, page.categoriesButtonTitle, page.categories);
    chart.initialSegmentIndex = page.initialSegmentIndex;
    chart.seeAllAction = seeAllActionForChart(objectGraph, chart);
    return chart;
}
/**
 * Render a {@linkcode ChartsHubPage} from constituent {@linkcode TopChartsPage}s
 */
export function renderChartsHub(objectGraph, appsPage, gamesPage) {
    const appsCharts = topChartFromPage(objectGraph, appsPage, objectGraph.loc.string("TopCharts.Hub.Apps.Title"));
    const gamesCharts = topChartFromPage(objectGraph, gamesPage, objectGraph.loc.string("TopCharts.Hub.Games.Title"));
    const hubPage = new ChartsHubPage([appsCharts, gamesCharts]);
    hubPage.title = objectGraph.loc.string("TopCharts.Hub.Title");
    return hubPage;
}
//# sourceMappingURL=charts-hub.js.map