/**
 * Adds the required url query params to a media API request for Contingent Items
 */
export function configureContingentItemsForMediaRequest(mediaApiRequest) {
    mediaApiRequest.includingScopedRelationships("contingent-items", ["trunk-app", "branch-app", "branch"]);
    mediaApiRequest.includingViews(["events-and-offers", "standalone-merchandised-in-apps"]);
    mediaApiRequest.includingScopedAttributes("contingent-items", ["name", "subtitle", "additionalTerms"]);
    mediaApiRequest.includingMetaKeys("contingent-items:branch", ["contingentItemOffer"]);
    mediaApiRequest.includingMetaKeys("contingent-items:association.trunks", ["useTrunkArtwork"]);
    mediaApiRequest.includingAssociateKeys("contingent-items", ["trunks"]);
}
/**
 * Adds the required url query params to a groupings API request for Contingent Items
 */
export function configureContingentItemsForGroupingRequest(mediaApiRequest) {
    mediaApiRequest.includingScopedRelationships("contingent-items", ["trunk-app", "branch-app", "branch"]);
    mediaApiRequest.includingScopedAttributes("contingent-items", ["name", "subtitle", "additionalTerms"]);
    mediaApiRequest.includingMetaKeys("contingent-items:branch", ["contingentItemOffer"]);
    mediaApiRequest.includingMetaKeys("contingent-items:association.trunks", ["useTrunkArtwork"]);
    mediaApiRequest.includingAssociateKeys("contingent-items", ["trunks"]);
}
export function configureTagsForMediaRequest(mediaApiRequest) {
    mediaApiRequest.enablingFeature("tags");
    mediaApiRequest.includingScopedAttributes("tags", ["editorialArtwork"]);
    mediaApiRequest.addingQuery("associate[tags]", "apps");
    mediaApiRequest.includingScopedRelationships("editorial-elements", ["contents", "see-all-contents"]);
}
/**
 * Adds the required url query params to a media API request for Winback Offer items
 */
export function configureOfferItemsForMediaRequest(mediaApiRequest) {
    mediaApiRequest.includingScopedRelationships("offer-items", ["salables"]);
    mediaApiRequest.includingScopedAttributes("offer-items", [
        "title",
        "subtitle",
        "additionalTerms",
        "redemptionExpirationDate",
    ]);
    mediaApiRequest.includingMetaKeys("offer-items:salables", ["discountOffer"]);
    mediaApiRequest.includingKindsKeys("offer-items", ["winback"]);
}
//# sourceMappingURL=url-mapping-utils.js.map