import { PageFacets } from "../../api/models";
import { isDefinedNonNullNonEmpty, isNullOrEmpty } from "../../foundation/json-parsing/server-data";
import { Parameters } from "../../foundation/network/url-constants";
import { shouldUsePrerenderedIconArtwork } from "../content/content";
import { binCompatGamesFacetOptionParameter, comingSoonAppsFacetOptionValue, comingSoonFacetOptionParameter, comingSoonGroupingFacetOptionValue, facetOptionsParameterMapping, sortCategoryFacetOptionValue, sortFacetOptionParameter, sortLastUpdatedFacetOptionValue, sortNameFacetOptionValue, sortReleaseDateFacetOptionValue, } from "./arcade-see-all-games-facets";
export function defaultRequestAttributes(objectGraph) {
    const attributes = [
        "editorialArtwork",
        "editorialVideo",
        "isAppleWatchSupported",
        "requiredCapabilities",
        "videoPreviewsByType",
        "screenshotsByType",
    ];
    if (objectGraph.appleSilicon.isSupportEnabled) {
        attributes.push("macRequiredCapabilities");
    }
    if (objectGraph.client.isMac) {
        attributes.push("hasMacIPAPackage");
    }
    if (objectGraph.client.isVision) {
        attributes.push("compatibilityControllerRequirement");
    }
    if (objectGraph.bag.enableUpdatedAgeRatings) {
        attributes.push("ageRating");
    }
    if (shouldUsePrerenderedIconArtwork(objectGraph)) {
        attributes.push("iconArtwork");
    }
    return attributes;
}
const defaultSparseCount = 4;
export function prepareRequestWithSelectedFacets(request, selectedFacetOptions) {
    let includeSparseCount = false;
    for (const key of Object.keys(selectedFacetOptions)) {
        // We need to choose the correct value for the coming soon parameter if coming soon is enabled.
        if (key === comingSoonFacetOptionParameter && isDefinedNonNullNonEmpty(selectedFacetOptions[key])) {
            const selectedSortValue = selectedFacetOptions[sortFacetOptionParameter];
            if (isDefinedNonNullNonEmpty(selectedSortValue)) {
                switch (selectedSortValue[0].value) {
                    case sortReleaseDateFacetOptionValue:
                    case sortLastUpdatedFacetOptionValue:
                        selectedFacetOptions[key][0].value = comingSoonGroupingFacetOptionValue;
                        break;
                    case sortNameFacetOptionValue:
                        selectedFacetOptions[key][0].value = comingSoonAppsFacetOptionValue;
                        break;
                    case sortCategoryFacetOptionValue:
                        selectedFacetOptions[key][0].value = comingSoonAppsFacetOptionValue;
                        includeSparseCount = true;
                        break;
                    default:
                        break;
                }
            }
        }
        // We need to choose the correct value for the bin compat games parameter if it is disabled.
        if (key === binCompatGamesFacetOptionParameter && isNullOrEmpty(selectedFacetOptions[key])) {
            selectedFacetOptions[key] = facetOptionsParameterMapping[Parameters.binCompatGames].false;
        }
    }
    // We include the sparse count when dealing with the category sort.
    if (includeSparseCount) {
        request.withSparseCount(defaultSparseCount);
    }
    for (const key of Object.keys(selectedFacetOptions)) {
        const requestValues = PageFacets.requestValuesForSelectedFacetOptions(selectedFacetOptions[key]);
        if (isDefinedNonNullNonEmpty(requestValues)) {
            if (isDefinedNonNullNonEmpty(requestValues.value)) {
                request.addingQuery(key, requestValues.value);
            }
            for (const additionalKey of Object.keys(requestValues.additionalKeyValuePairs)) {
                request.addingQuery(additionalKey, requestValues.additionalKeyValuePairs[additionalKey]);
            }
        }
    }
}
//# sourceMappingURL=arcade-see-all-request.js.map