import { DynamicUIRequestInfo, FlowAction } from "../../api/models";
/**
 * Run a given URL through all the different web view regexes we have in the bag and return a
 * flow action with the correct page type for this url. This is essentially what AMSURLParser
 * is doing, however that does not work for App Store the way we route URLs.
 *
 * @param objectGraph The App Store object graph.
 * @param urlString The string to create the appropriate FlowAction for.
 * @returns A FlowAction appropriate for the provided URL.
 */
export function flowActionForAccountURL(objectGraph, urlString) {
    // Dynamic UI
    const dynamicUIRegexPatterns = objectGraph.bag.dynamicUIRegexStrings;
    for (const pattern of dynamicUIRegexPatterns) {
        const regexPattern = pattern.replace(/\//g, "\\/");
        const dynamicUIPattern = new RegExp(regexPattern);
        if (dynamicUIPattern.test(urlString)) {
            const action = new FlowAction("dynamicUI", urlString);
            action.pageData = new DynamicUIRequestInfo(objectGraph.bag.metricsTopic);
            return action;
        }
    }
    // Web UI regex check
    const webViewRegexPatterns = objectGraph.bag.webViewRegexStrings;
    for (const pattern of webViewRegexPatterns) {
        const regexPattern = pattern.replace(/\//g, "\\/");
        const webViewPattern = new RegExp(regexPattern);
        if (webViewPattern.test(urlString)) {
            return new FlowAction("webView", urlString);
        }
    }
    /// Last of all try to allow the finance view controller to handle this url
    return new FlowAction("finance", urlString);
}
//# sourceMappingURL=account-links-regex-parser.js.map