/**
 * Created by km on 2/13/17.
 */
import * as models from "./index";
import * as metrics from "./metrics/metrics";
/** @public */
export class TopChartSegment extends models.Model {
    constructor(shortName, longName, chart, shelfModels) {
        super();
        this.shortName = shortName;
        this.longName = longName;
        this.chart = chart;
        this.shelves = shelfModels;
        this.nextPage = null;
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
/** @public */
export class TopChartCategory extends models.Category {
    constructor(category, url, children) {
        super(category.name, category.genreId, category.artwork, category.ageBandId, children);
        this.shortName = this.name;
        this.longName = this.name;
        this.url = url;
    }
}
/**
 * Shared "Top Charts" view-model
 *
 * @see {@linkcode TopChartsPage} for when "Top Charts" should be rendered as a page
 * @see {@linkcode ChartsHubChart} for when a "chart" exists on a page with other "charts"
 */
export class TopChartsPage extends models.Model {
    constructor(genreId, ageBandId, title, segments, categoriesButtonTitle, categories) {
        super();
        this.genreId = genreId;
        this.ageBandId = ageBandId;
        this.title = title;
        this.segments = segments;
        this.categoriesButtonTitle = categoriesButtonTitle;
        this.categories = categories;
        this.initialSegmentIndex = 0;
    }
}
/**
 * A single chart within a {@linkcode ChartsHubPage}
 */
export class ChartsHubChart extends TopChartsPage {
}
/**
 * View-model for the "Charts Hub" page
 *
 * This is used by the "web" client to power the charts overview, which includes
 * multiple charts in the same view
 */
export class ChartsHubPage extends models.Model {
    constructor(charts) {
        super();
        this.charts = charts;
    }
}
//# sourceMappingURL=top-charts.js.map