import * as base from "./base";
import * as metrics from "./metrics/metrics";
export var AdPlacementBehavior;
(function (AdPlacementBehavior) {
    AdPlacementBehavior["insertIntoShelf"] = "insertIntoShelf";
    AdPlacementBehavior["replaceOrganic"] = "replaceOrganic";
    AdPlacementBehavior["dropAd"] = "dropAd";
})(AdPlacementBehavior || (AdPlacementBehavior = {}));
/** @public */
export class TodayCardMedia extends base.ViewModel {
    constructor(kind) {
        super();
        this.kind = kind;
    }
    /**
     * @returns The best background color for the media. This is used to
     * determine the color the section background gradients. If undefined, the
     * default section background color will be used.
     */
    bestBackgroundColor() {
        return undefined;
    }
}
/** @public */
export class TodayCardMediaWithArtwork extends TodayCardMedia {
    constructor(kind, artworks, videos, artworkLayoutsWithMetrics) {
        super(kind);
        this.artworks = artworks;
        this.videos = videos;
        this.artworkLayoutsWithMetrics = artworkLayoutsWithMetrics;
    }
    bestBackgroundColor() {
        var _a, _b, _c;
        return (_b = (_a = this.videos[0]) === null || _a === void 0 ? void 0 : _a.preview.backgroundColor) !== null && _b !== void 0 ? _b : (_c = this.artworks[0]) === null || _c === void 0 ? void 0 : _c.backgroundColor;
    }
}
/** @public */
export class TodayCardMediaHero extends TodayCardMediaWithArtwork {
    constructor(artworks, videos) {
        super("hero", artworks, videos, []);
    }
    isValid() {
        const isArtworkValid = this.artworks.every((artwork) => artwork.isValid()) && this.artworks.length > 0;
        const isVideoValid = this.videos.every((video) => video.isValid()) && this.videos.length > 0;
        return (isArtworkValid || isVideoValid) && super.isValid();
    }
}
/** @public */
export class TodayCardMediaArtwork extends TodayCardMediaWithArtwork {
    constructor(artworks, videos, artworkLayoutsWithMetrics, titleBackingGradient) {
        super("artwork", artworks, videos, artworkLayoutsWithMetrics);
        this.titleBackingGradient = titleBackingGradient;
    }
}
/** @public */
export class TodayCardMediaAppIcon extends TodayCardMedia {
    constructor(icon) {
        super("appIcon");
        this.icon = icon;
    }
    bestBackgroundColor() {
        return this.icon.backgroundColor;
    }
}
/** @public */
export class TodayCardMediaBrandedSingleApp extends TodayCardMediaWithArtwork {
    constructor(icon, artworks, videos, artworkLayoutsWithMetrics, titleBackingGradient) {
        super("brandedSingleApp", artworks, videos, artworkLayoutsWithMetrics);
        this.icon = icon;
        this.titleBackingGradient = titleBackingGradient;
    }
    bestBackgroundColor() {
        var _a;
        return (_a = super.bestBackgroundColor()) !== null && _a !== void 0 ? _a : this.icon.backgroundColor;
    }
}
/** @public */
export class TodayCardMediaList extends TodayCardMediaWithArtwork {
    constructor(lockups, artworks, videos, artworkLayoutsWithMetrics, marketingText, isMediaDark) {
        super("list", artworks, videos, artworkLayoutsWithMetrics);
        this.lockups = lockups;
        this.marketingText = marketingText;
        this.isMediaDark = isMediaDark;
    }
}
/** @public */
export class TodayCardMediaMultiApp extends TodayCardMedia {
    constructor(lockups, additionalText) {
        super("multiApp");
        this.lockups = lockups;
        this.additionalText = additionalText;
    }
}
/** @public */
export class TodayCardInAppPurchase extends TodayCardMedia {
    constructor(lockup) {
        super("inAppPurchase");
        this.lockup = lockup;
    }
    bestBackgroundColor() {
        return this.lockup.icon.backgroundColor;
    }
}
/** @public */
export class TodayCardMediaRiver extends TodayCardMedia {
    constructor(lockups) {
        super("river");
        this.lockups = lockups;
        this.lockupImpressionLimit = 10;
    }
}
/** @public */
export class TodayCardMediaGrid extends TodayCardMedia {
    constructor(lockups, artworkGridType) {
        super("grid");
        this.lockups = lockups;
        this.artworkGridType = artworkGridType;
        this.lockupImpressionLimit = 3;
    }
}
/** @public */
export class TodayCardMediaVideo extends TodayCardMediaWithArtwork {
    constructor(videos, artworkLayoutsWithMetrics, description) {
        super("video", [], videos, artworkLayoutsWithMetrics);
        this.description = description;
    }
}
/** @public */
export class TodayCardMediaAppEvent extends TodayCardMediaWithArtwork {
    constructor(formattedDates, startDate, tintColor, artworks, videos, artworkLayoutsWithMetrics, blurStyle) {
        super("appEvent", artworks, videos, artworkLayoutsWithMetrics);
        this.formattedDates = formattedDates;
        this.startDate = startDate;
        this.tintColor = tintColor;
        this.blurStyle = blurStyle;
    }
}
/** @public */
export class TodayCardMediaMediumLockupWithAlignedRegion extends TodayCardMedia {
    constructor(mediumAdLockupWithAlignedRegionBackground) {
        super("mediumLockupWithAlignedRegion");
        this.mediumAdLockupWithAlignedRegionBackground = mediumAdLockupWithAlignedRegionBackground;
    }
}
/** @public */
export class TodayCardMediaMediumLockupWithScreenshots extends TodayCardMedia {
    constructor(mediumAdLockupWithScreenshotsBackground) {
        super("mediumLockupWithScreenshots");
        this.mediumAdLockupWithScreenshotsBackground = mediumAdLockupWithScreenshotsBackground;
    }
}
/**
 * @public
 * Media for a today card with a single lockup.
 */ export class TodayCardMediaSingleLockup extends TodayCardMedia {
    constructor(condensedAdLockupWithIconBackground) {
        super("singleLockup");
        this.condensedAdLockupWithIconBackground = condensedAdLockupWithIconBackground;
    }
    /**
     * @returns The best background color for the media. This is used to
     * determine the color the section background gradients. If undefined, the
     * default section background color will be used.
     */
    bestBackgroundColor() {
        var _a;
        return (_a = this.condensedAdLockupWithIconBackground) === null || _a === void 0 ? void 0 : _a.backgroundArtwork.backgroundColor;
    }
}
/** @public */
export class TodayCardOverlay extends base.Model {
    constructor(kind) {
        super();
        this.kind = kind;
    }
}
/** @public */
export class TodayCardLockupOverlay extends TodayCardOverlay {
    constructor(lockup) {
        super("lockup");
        this.lockup = lockup;
        this.displaysIcon = true;
    }
}
/**
 * @public
 * Variant of `TodayCardLockupOverlay` with additional functionality,
 * like optionally showing a transient `TodayCardParagraphOverlay` style overlay
 */
export class TodayCardMarketingLockupOverlay extends TodayCardOverlay {
    constructor(lockup, paragraph, hideBackground, artworkBackgroundColor) {
        super("marketingLockup");
        this.lockup = lockup;
        this.paragraph = paragraph;
        this.hideBackground = hideBackground;
        this.artworkBackgroundColor = artworkBackgroundColor;
    }
}
/** @public */
export class TodayCardLockupListOverlay extends TodayCardOverlay {
    constructor(lockups) {
        super("lockupList");
        this.lockups = lockups;
    }
}
/** @public */
export class TodayCardParagraphOverlay extends TodayCardOverlay {
    constructor(paragraph, style) {
        super("paragraph");
        this.paragraph = paragraph;
        this.style = style;
    }
}
/** @public */
export class TodayCardActionOverlay extends TodayCardOverlay {
    constructor(action) {
        super("action");
        this.action = action;
    }
}
/** @public */
export class TodayCardThreeLineOverlay extends TodayCardOverlay {
    constructor(heading, title, description) {
        super("threeLine");
        this.heading = heading;
        this.title = title;
        this.description = description;
    }
}
/**
 * @public
 * Overlay for Acquisition Editorial Items that promote the Arcade Service.
 */
export class TodayCardArcadeLockupOverlay extends TodayCardOverlay {
    constructor(arcadeLockup) {
        super("arcadeLockup");
        this.arcadeLockup = arcadeLockup;
    }
}
/**
 * @public
 * Overlay for App Event lockups.
 */
export class TodayCardAppEventLockupOverlay extends TodayCardOverlay {
    constructor(lockup) {
        super("appEventLockup");
        this.lockup = lockup;
    }
}
// endregion
// region Cards
/** @public */
export class TodayCard extends base.ViewModel {
    constructor() {
        super();
        this.heading = undefined;
        this.title = undefined;
        this.shortTitle = undefined;
        this.titleArtwork = undefined;
        this.media = undefined;
        this.heroMedia = undefined;
        this.overlay = undefined;
        this.style = undefined;
        this.clickAction = undefined;
        this.backgroundColor = undefined;
        this.inlineDescription = undefined;
        this.collapsedHeading = undefined;
        this.editorialDisplayOptions = undefined;
        this.supportsMediaMirroring = undefined;
    }
}
/** @public */
export class InlineTodayCards extends base.ViewModel {
    constructor(cards) {
        super();
        this.cards = cards;
    }
}
// endregion
/** @public */
export class TodayPage extends base.Model {
    constructor(shelfModels, onboardingCardIds, title, tabTitle, titleDetail, shortTitleDetail) {
        super();
        this.shelves = shelfModels;
        this.title = title;
        this.titleDetail = titleDetail;
        this.shortTitleDetail = shortTitleDetail;
        this.tabTitle = tabTitle;
        this.nextPage = null;
        if (onboardingCardIds) {
            this.onboardingCardIds = onboardingCardIds;
        }
        else {
            this.onboardingCardIds = [];
        }
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
//# sourceMappingURL=today-page.js.map