/**
 * Created by km on 2/13/17.
 */
import { isSome } from "@jet/environment/types/optional";
import * as base from "./base";
/** @public */
export class InformationContainer extends base.Model {
    constructor(annotationGroups) {
        super();
        this.annotationGroups = annotationGroups;
    }
}
/** @public */
export class ImpressionableArtwork extends base.ViewModel {
    constructor(art) {
        super();
        this.art = art;
    }
}
/** @public */
export class AppShowcase extends base.Model {
    constructor(type, lockup) {
        super();
        this.type = type;
        this.lockup = lockup;
    }
}
/** @public */
export class Banner extends base.Model {
    constructor(message, focusedMessage, action, fullProductAction, leadingArtwork, leadingArtworkTintColor, includeBackgroundBorder, kind, hideCriteria) {
        super();
        this.message = message;
        this.focusedMessage = focusedMessage;
        this.action = action;
        this.fullProductAction = fullProductAction;
        this.leadingArtwork = leadingArtwork;
        this.leadingArtworkTintColor = leadingArtworkTintColor;
        this.includeBackgroundBorder = includeBackgroundBorder;
        this.kind = kind;
        this.hideCriteria = hideCriteria;
    }
}
/**
 * @public
 * Defines which banner to show for various app states so the client can update dynamically.
 */
export class AppStateBanner extends base.Model {
    constructor(unknownBanner, buyBanner, downloadBanner, updateBanner, openBanner) {
        super();
        this.unknownBanner = unknownBanner;
        this.buyBanner = buyBanner;
        this.downloadBanner = downloadBanner;
        this.updateBanner = updateBanner;
        this.openBanner = openBanner;
    }
}
/** @public */
export class InAppPurchaseShowcase extends base.Model {
    constructor(lockup) {
        super();
        this.lockup = lockup;
    }
}
// endregion
/** @public */
export class ProductMediaItem extends base.Model {
}
/** @public */
export class ProductMedia extends base.Model {
    constructor(items, mediaPlatform, allPlatforms, platformDescription, allPlatformsDescription, allPlatformsDescriptionPlacement) {
        super();
        this.items = items;
        this.mediaPlatform = mediaPlatform;
        this.allPlatforms = allPlatforms;
        this.platformDescription = platformDescription;
        this.allPlatformsDescription = allPlatformsDescription;
        this.allPlatformsDescriptionPlacement = allPlatformsDescriptionPlacement;
    }
}
/** @public */
export class ProductCapability extends base.Model {
    constructor(type, title, caption, captionTrailingArtwork, linkAction, artwork, artworkTintColor) {
        super();
        this.type = type;
        this.title = title;
        this.caption = caption;
        this.captionTrailingArtwork = captionTrailingArtwork;
        this.linkAction = linkAction;
        this.artwork = artwork;
        this.artworkTintColor = artworkTintColor;
    }
}
/** @public */
export class ProductDescription extends base.Model {
    constructor(paragraph, developerLinks, tags, developerAction) {
        super();
        this.paragraph = paragraph;
        this.developerAction = developerAction;
        this.tags = tags;
        this.developerLinks = developerLinks;
    }
}
/** @public */
export class Footnote extends base.Model {
    constructor(text) {
        super();
        this.text = text;
        this.presentationStyle = [];
        this.clickAction = null;
    }
}
/** @public */
export class LockupContextMenuData extends base.Model {
}
/** @public */
export class Lockup extends base.ViewModel {
    isValid() {
        if (!this.title) {
            return false;
        }
        if (!this.icon || !this.icon.isValid()) {
            return false;
        }
        return super.isValid();
    }
}
/** @public */
export class ScreenshotsLockup extends Lockup {
    constructor() {
        super();
        this.screenshots = [];
        /// Force a 4 screenshot portrait display style to ensure alignment with landscape screenshots
        this.screenshotsDisplayStyle = "four-screenshots";
    }
    isValid() {
        const hasScreenshots = this.screenshots && this.screenshots.length;
        if (!hasScreenshots) {
            return false;
        }
        return super.isValid();
    }
}
/** @public */
export class MixedMediaLockup extends Lockup {
    constructor() {
        super();
        this.screenshots = [];
        this.trailers = [];
        this.overrideLockupPosition = null;
        this.screenshotsDisplayStyle = "control";
        this.metadataRibbonItems = [];
        this.showMetadataInformationInLockup = false;
        this.alignedRegionArtwork = null;
        this.alignedRegionVideo = null;
    }
}
export class UpdatesLockup extends Lockup {
    constructor() {
        super();
        this.whatsNew = undefined;
        this.version = undefined;
        this.size = undefined;
        this.externalVersionId = undefined;
        this.releaseDate = undefined;
        this.installDate = undefined;
    }
}
/**
 * @public
 * The metadata ribbon item used to contain any content of a metadata ribbon view.
 * Keys will be present based on which metadata ribbon item type is being presented.
 * This is using specific keys rather than creating them on the fly because the key
 * names get mangled if they're not defined.
 */
export class MetadataRibbonItem extends base.ViewModel {
    constructor(viewType) {
        super();
        this.viewType = viewType;
        this.moduleType = null;
        this.labelText = null;
        this.borderedText = null;
        this.highlightedText = null;
        this.starRating = null;
        this.secondaryViewPlacement = "leading";
        this.artwork = null;
        this.maxCharacterCount = null;
        this.truncationLegibilityCharacterCountThreshold = null;
        this.allowsTruncation = null;
    }
}
/** @public */
export class TrailersLockup extends Lockup {
    isValid() {
        const hasTrailers = this.trailers && this.trailers.isValid();
        if (!hasTrailers) {
            return false;
        }
        if (!this.editorialTagline || this.editorialTagline.length === 0) {
            return false;
        }
        return super.isValid();
    }
}
/** @public */
export class Trailers extends base.Model {
    constructor(videos, mediaPlatform) {
        super();
        if (videos) {
            this.videos = videos;
        }
        if (mediaPlatform) {
            this.mediaPlatform = mediaPlatform;
        }
    }
    isValid() {
        return this.videos && this.videos.length > 0 && super.isValid();
    }
}
/** @public */
export class InAppPurchaseLockup extends Lockup {
}
/**
 * @public
 * This is a lockup that represents the Arcade *service* (in contrast to lockups for Arcade *apps*)
 * It is used in:
 * - Today Card Overlay (iOS)
 * - Article Persistent Lockup  (iOS, macOS)
 * - Maybe more
 *
 * This object does *not* subclass `Lockup`, as we cannot populate the app-specific properties. Decision was made to use a separate codepath altogether for delivering this
 * fake lockup to views we otherwise display standard `Lockup`, as opposed to trying to reconcile the use-cases at this time.
 *
 * This class deliberately maintains two button actions to fire for subscribed and unsubscribed state, respectively, instead of a single hypothetical `ArcadeStateAction`
 * that switches behavior based on subscription state. This is since the subscription state can switch between model apply time (what is visually represented in UI),
 * and when it is run in action runner.
 */
export class ArcadeLockup extends base.ViewModel {
}
export class ImageLockup extends base.ViewModel {
    constructor(artwork, lockup, caption, title, isDark = false) {
        super();
        this.isDark = false;
        this.artwork = artwork;
        this.lockup = lockup;
        this.caption = caption;
        this.title = title;
        this.isDark = isDark;
    }
    isValid() {
        return this.lockup.isValid() && this.artwork.isValid();
    }
}
/** @public */
export class TitledParagraph extends base.Model {
    constructor(text, style, mediaType) {
        super();
        this.text = text;
        this.style = style;
        this.mediaType = mediaType;
        this.wantsCollapsedNewlines = true;
    }
}
/** @public */
export class EditorialCard extends base.ViewModel {
    constructor() {
        super();
        this.adamId = null;
        this.caption = null;
        this.title = null;
        this.subtitle = null;
        this.artwork = null;
        this.shelfBackground = null;
        this.clickAction = null;
        this.decorations = [];
        this.flowPreviewActionsConfiguration = null;
        this.appEventFormattedDates = null;
        this.mediaOverlayStyle = null;
    }
    isValid() {
        if (!this.clickAction) {
            return false;
        }
        if (!this.artwork || !this.artwork.isValid()) {
            return false;
        }
        if (!this.caption || !this.title) {
            return false;
        }
        return super.isValid();
    }
}
/**
 * @public
 * Used for:
 * - Arcade Continue Playing.
 */
export class VideoCard extends base.ViewModel {
    constructor() {
        super();
        this.flowPreviewActionsConfiguration = null;
    }
}
/**
 * @public
 * Used within a `RibbonBar` which is a horizontal scrolling bar that contains multiple `RibbonBarItem`s.
 * E.g. a `RibbonBarItem` that defines an Arcade category within an Arcade category ribbon bar.
 *
 * Each bar item should have a title and a click action alongside with an optional artwork.
 * Empty artworks are potentially handled by a fallback icon by client side.
 */
export class RibbonBarItem extends base.ViewModel {
    constructor(title, clickAction) {
        super();
        this.title = title;
        this.clickAction = clickAction;
        this.artwork = null;
        this.accessibilityLabel = null;
    }
}
/** @public */
export class Brick extends base.ViewModel {
    constructor() {
        super();
        this.artworks = null;
        this.accessibilityLabel = null;
        this.shortEditorialDescription = null;
        this.clickAction = null;
        this.personalizationStyle = "none";
        this.shelfBackground = null;
        this.flowPreviewActionsConfiguration = null;
        this.editorialDisplayOptions = {};
        this.artworkSafeArea = null;
        this.textSafeArea = null;
    }
    isValid() {
        var _a, _b, _c, _d;
        const hasValidArtwork = (_b = (_a = this.artworks) === null || _a === void 0 ? void 0 : _a.every((artwork, index) => {
            return isSome(artwork) && artwork.isValid();
        })) !== null && _b !== void 0 ? _b : false;
        const hasCollectionIcons = ((_d = (_c = this.collectionIcons) === null || _c === void 0 ? void 0 : _c.length) !== null && _d !== void 0 ? _d : 0) > 0;
        const hasBackgroundColor = isSome(this.backgroundColor);
        return (isSome(this.clickAction) && (hasValidArtwork || hasCollectionIcons || hasBackgroundColor) && super.isValid());
    }
}
/** @public */
export class EditorialLink extends base.ViewModel {
    constructor(descriptionText, summaryText, clickAction, linkPresentationEnabled = true) {
        super();
        this.descriptionText = descriptionText;
        this.summaryText = summaryText;
        this.clickAction = clickAction;
        this.linkPresentationEnabled = linkPresentationEnabled;
    }
}
/** @public */
export class SearchLink extends base.ViewModel {
    constructor(title, clickAction, artwork, imageName) {
        super();
        this.title = title;
        this.clickAction = clickAction;
        this.imageName = imageName;
        this.artwork = artwork;
    }
}
/** @public */
export class LinkableText extends base.Model {
    constructor(styledText, linkedSubstrings) {
        super();
        this.styledText = styledText;
        this.linkedSubstrings = linkedSubstrings;
    }
}
/** @public */
export class ProductPageLink extends base.Model {
    constructor(text, clickAction, systemImageName, adamIdForPurchaseHistoryFilter) {
        super();
        this.text = text;
        this.clickAction = clickAction;
        this.systemImageName = systemImageName;
        this.adamIdForPurchaseHistoryFilter = adamIdForPurchaseHistoryFilter;
    }
}
/** @public */
export class PreorderDisclaimer extends base.Model {
    constructor(disclaimer) {
        super();
        this.disclaimer = disclaimer;
    }
}
/** @public */
export class TitledButtonStack extends base.Model {
    constructor(buttons) {
        super();
        this.buttons = buttons;
    }
}
/** @public */
export class TitledButton extends base.Model {
    constructor(title, action) {
        super();
        this.title = title;
        this.action = action;
    }
}
/** @public */
export class FramedArtwork extends base.ViewModel {
    constructor(artwork, isFullWidth, captionMediaType = "text/plain", caption = null, ordinal = null, hasRoundedCorners = null) {
        super();
        this.artwork = artwork;
        this.isFullWidth = isFullWidth;
        this.hasRoundedCorners = typeof hasRoundedCorners === "boolean" ? hasRoundedCorners : !this.isFullWidth;
        this.ordinal = ordinal;
        this.caption = caption;
        this.captionMediaType = captionMediaType;
    }
}
/** @public */
export class FramedVideo extends base.ViewModel {
    constructor(video, isFullWidth, captionMediaType = "text/plain", caption = null, ordinal = null, hasRoundedCorners = null) {
        super();
        this.video = video;
        this.isFullWidth = isFullWidth;
        this.hasRoundedCorners = typeof hasRoundedCorners === "boolean" ? hasRoundedCorners : !this.isFullWidth;
        this.ordinal = ordinal;
        this.caption = caption;
        this.captionMediaType = captionMediaType;
    }
}
/** @public */
export class RoundedButton extends base.Model {
    constructor(type, title, hasDivider, action) {
        super();
        this.type = type;
        this.title = title;
        this.hasDivider = hasDivider;
        this.action = action;
    }
}
/** @public */
export class Quote extends base.ViewModel {
    constructor(text, credit, artwork, isFullWidthArtwork) {
        super();
        this.text = text;
        this.credit = credit;
        this.artwork = artwork;
        this.isFullWidthArtwork = isFullWidthArtwork || false;
    }
}
/** @public */
export class EditorialQuote extends base.ViewModel {
    constructor(text, attribution) {
        super();
        this.text = text;
        this.attribution = attribution;
    }
}
/** @public */
export class HorizontalRule extends base.Model {
    constructor(style, ruleColor, isFullWidth) {
        super();
        this.style = style;
        this.color = ruleColor;
        this.isFullWidth = isFullWidth;
    }
}
/**
 * @public
 * A horizontal scrolling bar that contains multiple `RibbonBarItem`s.
 *
 * E.g. category ribbon bar displaying different Arcade categories in a horizontal scrolling bar.
 */
export class RibbonBar extends base.ViewModel {
    constructor(items) {
        super();
        this.items = items;
    }
}
/** @public */
export class InformationRibbon extends base.ViewModel {
    constructor(badges, hasTopSeparator, hasBottomSeparator, separatorsAreFullWidth, alignment) {
        super();
        this.badges = badges;
        this.hasTopSeparator = hasTopSeparator;
        this.hasBottomSeparator = hasBottomSeparator;
        this.separatorsAreFullWidth = separatorsAreFullWidth;
        this.alignment = alignment;
    }
}
// region Client Control Button
/**
 * @public
 * A client control button is an button appearing within Article pages.
 * This is currently used so MAS editorial articles to link into OS Updates in preferences.
 */
export class ClientControlButton extends base.ViewModel {
    constructor(title, buttonAction) {
        super();
        this.title = title;
        this.buttonAction = buttonAction;
    }
}
/** @public */
export class BreakoutDetails extends base.Model {
    constructor(title, description, badgeType, callToActionButtonAction, backgroundStyle, textAlignment) {
        super();
        this.badgeType = badgeType;
        this.badge = badgeType.title;
        this.title = title;
        this.description = description;
        this.callToActionButtonAction = callToActionButtonAction;
        this.backgroundStyle = backgroundStyle;
        this.textAlignment = textAlignment;
    }
}
/** @public */
export class LargeHeroBreakout extends base.ViewModel {
    constructor(details, detailsDisplayProperties, heading, artwork, video, collectionIcons, backgroundColor) {
        super();
        this.details = details;
        this.detailsDisplayProperties = detailsDisplayProperties;
        this.heading = heading;
        this.artwork = artwork;
        this.video = video;
        this.collectionIcons = collectionIcons;
        this.backgroundColor = backgroundColor;
        this.editorialDisplayOptions = {};
    }
}
/** @public */
export class SmallBreakout extends base.ViewModel {
    constructor(details, iconArtwork, backgroundColor) {
        super();
        this.details = details;
        this.iconArtwork = iconArtwork;
        this.backgroundColor = backgroundColor;
    }
}
/**
 * The `Placeholder` is a dummy model used so a shelf with content type Placeholder can be populated with items representing the amount of placeholders to show
 */
export class Placeholder extends base.ViewModel {
}
// region ArcadeShowcase
/**
 * @public
 * The `ArcadeShowcase` is a model that is similar to the upsell breakout on the grouping pages, but appears inline in article pages.
 * This module is specialized for Arcade service, since we don't have other subscription services currently.
 * On some platforms, it may display some icon artwork.
 */
export class ArcadeShowcase extends base.ViewModel {
    /**
     * Initialize arcade showcase with required values
     * @param unsubscribedAction Action to run in non-subscribed state.
     * @param subscribedAction Action to run in subscribed state.
     */
    constructor(unsubscribedAction, subscribedAction) {
        super();
        this.unsubscribedAction = unsubscribedAction;
        this.subscribedAction = subscribedAction;
    }
}
/** @public */
export class GameCenterReengagement extends base.ViewModel {
    constructor(badgeGlyph, badge, title, subtitle, achievement, lockup, backgroundColor, backgroundArtwork, heroAction) {
        super();
        this.badgeGlyph = badgeGlyph;
        this.badge = badge;
        this.title = title;
        this.subtitle = subtitle;
        this.achievement = achievement;
        this.backgroundColor = backgroundColor;
        this.backgroundArtwork = backgroundArtwork;
        this.lockup = lockup;
        this.heroAction = heroAction;
    }
}
export class UnifiedMessage extends base.ViewModel {
    constructor(placement, context, deliveryMethod) {
        super();
        this.placement = placement;
        this.context = context;
        this.deliveryMethod = deliveryMethod !== null && deliveryMethod !== void 0 ? deliveryMethod : "pushAndPull";
    }
}
export const genericShelfBatchGroupBase = "shelfBatchGroup_";
export var IncompleteShelfFetchStrategy;
(function (IncompleteShelfFetchStrategy) {
    /**
     * Indicates the shelf should be fetched as soon as the page is loaded,
     * this is the behavior we've always had, where all incomplete shelves are
     * fetched after the page loads
     */
    IncompleteShelfFetchStrategy["OnPageLoad"] = "onPageLoad";
    /**
     * Indicates the shelf should be fetched when it is about to be scrolled into view
     */
    IncompleteShelfFetchStrategy["OnShelfWillAppear"] = "onShelfWillAppear";
})(IncompleteShelfFetchStrategy || (IncompleteShelfFetchStrategy = {}));
// Describes the snapping behaviour for horizontally scrolling shelves.
export var ShelfHorizontalScrollTargetBehavior;
(function (ShelfHorizontalScrollTargetBehavior) {
    // The default behaviour, where scrolling will snap to the leading edge of the view.
    ShelfHorizontalScrollTargetBehavior["ViewAligned"] = "viewAligned";
    // Scrolling will snap so that views are center aligned in their container. Primarily
    // used for large components that take up most of the container.
    ShelfHorizontalScrollTargetBehavior["CenterAligned"] = "centerAligned";
})(ShelfHorizontalScrollTargetBehavior || (ShelfHorizontalScrollTargetBehavior = {}));
/** @public */
export class Shelf extends base.ViewModel {
    constructor(contentType, marker = null, items = null) {
        super();
        // - Item Properties
        this.contentType = contentType;
        this.marker = marker;
        this.items = items || [];
        this.header = undefined;
        // - Incomplete Shelf Properties
        this.url = null;
        this.mergeWhenFetched = false;
        this.fetchStrategy = IncompleteShelfFetchStrategy.OnPageLoad;
        this.batchGroup = null;
        // - Overflow Properties
        this.seeAllAction = null;
        // - Footer Properties
        this.footerTitle = null;
        this.footerAction = null;
        // - Presentation Properties
        this.eyebrow = null;
        this.eyebrowArtwork = null;
        this.footerStyle = null;
        this.title = null;
        this.titleArtwork = null;
        this.subtitle = null;
        this.isHorizontal = false;
        this.isHidden = false;
        this.rowsPerColumn = null;
        this.background = { type: "none" };
        this.contentsMetadata = { type: "none" };
        // - Personalization & Filtering Properties
        this.isPersonalized = false;
        this.shouldFilterApps = false;
    }
}
/** @public */
export var ShelfBackgroundGradientLocation;
(function (ShelfBackgroundGradientLocation) {
    ShelfBackgroundGradientLocation["TopLeading"] = "topLeading";
    ShelfBackgroundGradientLocation["Top"] = "top";
    ShelfBackgroundGradientLocation["TopTrailing"] = "topTrailing";
    ShelfBackgroundGradientLocation["Trailing"] = "trailing";
    ShelfBackgroundGradientLocation["BottomTrailing"] = "bottomTrailing";
    ShelfBackgroundGradientLocation["Bottom"] = "bottom";
    ShelfBackgroundGradientLocation["BottomLeading"] = "bottomLeading";
    ShelfBackgroundGradientLocation["Leading"] = "leading";
})(ShelfBackgroundGradientLocation || (ShelfBackgroundGradientLocation = {}));
export var GroupDisplayStyle;
(function (GroupDisplayStyle) {
    GroupDisplayStyle["Grid"] = "grid";
    GroupDisplayStyle["Hero"] = "hero";
    GroupDisplayStyle["Standard"] = "standard";
})(GroupDisplayStyle || (GroupDisplayStyle = {}));
/// The different artwork types we can display in the header
export var ShelfHeaderArtworkType;
(function (ShelfHeaderArtworkType) {
    /// The image displayed is a content icon
    ShelfHeaderArtworkType["Icon"] = "icon";
    /// The image displayed is a category image
    ShelfHeaderArtworkType["Category"] = "category";
})(ShelfHeaderArtworkType || (ShelfHeaderArtworkType = {}));
/** @public */
export class EditorialStoryCard extends base.ViewModel {
    constructor(title, artwork, video, heading, badge, description, clickAction) {
        super();
        this.title = title;
        this.artwork = artwork;
        this.video = video;
        this.heading = heading;
        this.badge = badge;
        this.description = description;
        this.clickAction = clickAction;
        this.shelfBackground = null;
        this.collectionIcons = null;
        this.editorialDisplayOptions = {};
    }
}
/** @public */
export class PosterLockup extends Lockup {
    isValid() {
        const hasPosterArtwork = this.posterArtwork;
        const hasPosterVideo = this.posterVideo;
        // We require at least one type of poster media.
        if (!(hasPosterArtwork || hasPosterVideo)) {
            return false;
        }
        return super.isValid();
    }
}
/** @public */
export class PageTab extends base.Model {
}
/** @public */
export class PageTabs extends base.Model {
    constructor() {
        super();
        /// The id is not from a payload and should be unique to the container
        this.id = random.nextUUID();
    }
}
//# sourceMappingURL=shelves.js.map