import * as dynamicGenericPage from "../dynamic-generic-page";
import * as models from "../base";
export class SearchChartsAndCategoriesPage extends dynamicGenericPage.DynamicGenericPage {
}
/**
 * @public
 * Model representing a piece of UI for a chart or category on the search landing page.
 */
export class SearchChartOrCategory extends models.ViewModel {
    constructor(title, artwork, collectionIcons, backgroundColor, badge, action, density, artworkSafeArea, textSafeArea) {
        super();
        this.title = title;
        this.artwork = artwork;
        this.collectionIcons = collectionIcons;
        this.backgroundColor = backgroundColor;
        this.badge = badge;
        this.action = action;
        this.density = density;
        this.artworkSafeArea = artworkSafeArea;
        this.textSafeArea = textSafeArea;
    }
}
/**
 * @public
 * Model representing a piece of UI for a medium ad lockup with custom creative artwork on the search landing page.
 */
export class MediumAdLockupWithAlignedRegionBackground extends models.ViewModel {
    constructor(lockup, alignedRegionArtwork) {
        super();
        this.lockup = lockup;
        this.alignedRegionArtwork = alignedRegionArtwork;
    }
}
/**
 * @public
 * Model representing a piece of UI for a medium ad lockup with screenshots on the search landing page.
 */
export class MediumAdLockupWithScreenshotsBackground extends models.ViewModel {
    constructor(lockup, screenshots, isAnimated, secondaryTextColor, backgroundColor, riverSpeed) {
        super();
        this.lockup = lockup;
        this.screenshots = screenshots;
        this.isAnimated = isAnimated;
        this.secondaryTextColor = secondaryTextColor;
        this.backgroundColor = backgroundColor;
        this.riverSpeed = riverSpeed;
    }
}
/**
 * @public
 * Model representing a piece of UI for a condensed ad lockup on the search landing page.
 */
export class CondensedAdLockupWithIconBackground extends models.ViewModel {
    constructor(lockup, backgroundArtwork) {
        super();
        this.lockup = lockup;
        this.backgroundArtwork = backgroundArtwork;
    }
}
export class SearchShelfAttributes {
    constructor(id, title, displayStyle, displayCount, hasSeeAll, seeAllLink, searchLandingItemDisplayStyle = null, searchShelfKind) {
        this.id = id;
        this.title = title;
        this.searchLandingItemDisplayStyle = searchLandingItemDisplayStyle;
        this.displayStyle = displayStyle;
        this.displayCount = displayCount;
        this.hasSeeAll = hasSeeAll;
        this.seeAllLink = seeAllLink;
        this.searchShelfKind = searchShelfKind;
    }
}
export var SearchLandingPageContentKind;
(function (SearchLandingPageContentKind) {
    SearchLandingPageContentKind["Suggestion"] = "Query";
    SearchLandingPageContentKind["CategoriesAndCharts"] = "EditorialLink";
    SearchLandingPageContentKind["Apps"] = "AppsLockup";
    SearchLandingPageContentKind["EditorialCollection"] = "EditorialCollection";
})(SearchLandingPageContentKind || (SearchLandingPageContentKind = {}));
export var SearchPageKind;
(function (SearchPageKind) {
    SearchPageKind[SearchPageKind["Default"] = 0] = "Default";
    SearchPageKind[SearchPageKind["CategoriesAndCharts"] = 1] = "CategoriesAndCharts";
})(SearchPageKind || (SearchPageKind = {}));
export var GenericSearchPageShelfDisplayStyleDensity;
(function (GenericSearchPageShelfDisplayStyleDensity) {
    GenericSearchPageShelfDisplayStyleDensity["Density1"] = "density_1";
    GenericSearchPageShelfDisplayStyleDensity["Density2"] = "density_2";
    GenericSearchPageShelfDisplayStyleDensity["Density3"] = "density_3";
})(GenericSearchPageShelfDisplayStyleDensity || (GenericSearchPageShelfDisplayStyleDensity = {}));
export var SearchLandingPageShelfItemIconKind;
(function (SearchLandingPageShelfItemIconKind) {
    SearchLandingPageShelfItemIconKind["Chiclet"] = "chiclet";
    SearchLandingPageShelfItemIconKind["App"] = "app";
    SearchLandingPageShelfItemIconKind["Symbol"] = "symbol";
})(SearchLandingPageShelfItemIconKind || (SearchLandingPageShelfItemIconKind = {}));
//# sourceMappingURL=search-categories.js.map