/**
 * Actions for Guided Search Feature
 */
import * as actions from "../actions";
/**
 * @public
 * An action that toggles a specified guided search token on and off.
 *
 * @note
 * The same instance of this object must handle both selection and deselection
 * as it can fire multiple times without JS refresh
 */
export class GuidedSearchTokenToggleAction extends actions.Action {
    constructor(targetToken, searchOrigin) {
        super("GuidedSearchTokenToggleAction");
        this.targetToken = targetToken;
        this.searchOrigin = searchOrigin;
    }
}
/**
 * @public
 * An action that changes the selected search entity (replacing existing, if any)
 */
export class SearchEntityChangeAction extends actions.Action {
    constructor(entity, searchOrigin) {
        super("SearchEntityChangeAction");
        this.entity = entity;
        this.searchOrigin = searchOrigin;
    }
}
//# sourceMappingURL=guided-search-actions.js.map