import * as models from "./index";
/** @public */
export class PrivacyHeader extends models.Model {
    constructor(bodyText, isDetailHeader, privacyTypes, bodyActions, supplementaryItems, seeDetailsAction) {
        super();
        this.bodyText = bodyText;
        this.isDetailHeader = isDetailHeader;
        this.privacyTypes = privacyTypes;
        this.bodyActions = bodyActions;
        this.supplementaryItems = supplementaryItems;
        this.seeDetailsAction = seeDetailsAction;
    }
}
/** @public */
export class PrivacyHeaderSupplementaryItem extends models.Model {
    constructor(bodyText, action) {
        super();
        this.bodyText = bodyText;
        this.action = action;
    }
}
/** @public */
export class PrivacyFooter extends models.Model {
    constructor(bodyText, actions, privacyTypesCount) {
        super();
        this.bodyText = bodyText;
        this.actions = actions;
        this.privacyTypesCount = privacyTypesCount;
    }
}
/** @public */
export class PrivacyType extends models.ViewModel {
    constructor(identifier, title, detail, artwork, style, purposes, categories, clickAction) {
        super();
        this.identifier = identifier;
        this.title = title;
        this.detail = detail;
        this.artwork = artwork;
        this.style = style;
        this.purposes = purposes;
        this.categories = categories;
        this.clickAction = clickAction;
        this.wantsScrollFocus = false;
    }
}
/** @public */
export class PrivacyPurpose extends models.Model {
    constructor(identifier, title, categories) {
        super();
        this.identifier = identifier;
        this.title = title;
        this.categories = categories;
    }
}
/** @public */
export class PrivacyCategory extends models.Model {
    constructor(identifier, title, artwork, style, dataTypes = []) {
        super();
        this.identifier = identifier;
        this.title = title;
        this.artwork = artwork;
        this.style = style;
        this.dataTypes = dataTypes;
        this.prefersSmallArtwork = false;
    }
}
/** @public */
export class PrivacyDefinition extends models.Model {
    constructor(title, definition) {
        super();
        this.title = title;
        this.definition = definition;
    }
}
//# sourceMappingURL=privacy.js.map