import { isSome } from "@jet/environment/types/optional";
import * as models from "./base";
/** @public */
export class PageFacetOption extends models.Model {
    constructor(title, value, metricsValue = null, systemImageName = undefined) {
        super();
        this.title = title;
        this.value = value;
        this.systemImageName = systemImageName;
        this.metricsValue = metricsValue;
    }
}
PageFacetOption.defaultValue = "pageFacetsDefaultValue";
PageFacetOption.trueValue = new PageFacetOption("true", "false");
PageFacetOption.falseValue = new PageFacetOption("false", "false");
/** @public */
export class PageFacetsFacet extends models.Model {
    constructor(id, parameterName, title, displayType, options = [], defaultOptions = null, metricsParameterName = null, clickAction = null, displayOptionsInline = false, showsSelectedOptions = false, isHiddenFromMenu = false) {
        super();
        this.id = id;
        this.parameterName = parameterName;
        this.title = title;
        this.displayType = displayType;
        this.defaultOptions = defaultOptions;
        this.options = options;
        this.metricsParameterName = metricsParameterName;
        this.clickAction = clickAction;
        this.displayOptionsInline = displayOptionsInline;
        this.showsSelectedOptions = showsSelectedOptions;
        this.isHiddenFromMenu = isHiddenFromMenu;
    }
}
/** @public */
export class PageFacetsGroup extends models.Model {
    constructor(facets = [], title = null) {
        super();
        this.title = title;
        this.facets = facets;
    }
}
/** @public */
export class PageFacets extends models.Model {
    constructor(facetGroups, allowsResetButton, resetButtonTitle) {
        super();
        this.facetGroups = facetGroups;
        this.allowsResetButton = allowsResetButton;
        this.resetButtonTitle = resetButtonTitle;
    }
    static isDefinedNonNullNonEmpty(object) {
        return isSome(object) && Object.keys(object).length !== 0;
    }
}
/**
 * Facet out nil values / join all values together returning the string used for a query parameter value
 * returns null if resulting string would be empty or selectedOptions is null
 * @param selectedOptions
 */
PageFacets.requestValuesForSelectedFacetOptions = function (selectedOptions) {
    if (PageFacets.isDefinedNonNullNonEmpty(selectedOptions)) {
        const facetOptionValue = selectedOptions
            .filter((option) => {
            return PageFacets.isDefinedNonNullNonEmpty(option.value);
        })
            .map((option) => {
            return option.value;
        })
            .join(",");
        const allFacetOptionValues = facetOptionValue.split("&");
        const primaryValue = allFacetOptionValues[0];
        const additionalQueryValues = allFacetOptionValues.splice(1);
        const additionalKeyValuePairs = {};
        for (const additionalQueryValue of additionalQueryValues) {
            const keyValue = additionalQueryValue.split("=");
            if (keyValue.length !== 2) {
                continue;
            }
            additionalKeyValuePairs[keyValue[0]] = keyValue[1];
        }
        return {
            value: primaryValue,
            additionalKeyValuePairs: additionalKeyValuePairs,
        };
    }
    else {
        return null;
    }
};
//# sourceMappingURL=page-facets.js.map