/**
 * Created by joel on 2/13/17.
 */
import * as JetMetrics from "@jet/environment/types/metrics";
import * as models from "../base";
// TS only allows extending **type information** in `declare module`s.
// These members **must** be initialized.
// TODO: The root cause for this workaround is because the Jet type `PageInvocationPoint` is not a `const enum`.
//       Consider changing the Jet type to a `const enum`, and the compiler will automatically inline these values.
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const extendedPageInvocationPoint = JetMetrics.PageInvocationPoint;
extendedPageInvocationPoint["search"] = "search";
extendedPageInvocationPoint["timer"] = "timer";
extendedPageInvocationPoint["never"] = "never";
extendedPageInvocationPoint["pageChange"] = "pageChange";
/** @public */
export class AppStoreMetricsData {
    constructor(fields, includingFields, excludingFields, topic, shouldFlush = false) {
        this.fields = fields;
        this.includingFields = includingFields;
        this.excludingFields = excludingFields;
        this.topic = topic;
        this.shouldFlush = shouldFlush;
    }
}
/** @public */
export class LintedMetricsEvent extends models.Model {
    constructor(fields) {
        super();
        this.fields = fields;
    }
}
/** @public */
export class ActionMetrics extends models.Model {
    constructor(events) {
        super();
        this.data = events || [];
        this.custom = {};
    }
    addMetricsData(data) {
        this.data.push(data);
    }
    addManyMetricsData(dataArray) {
        for (const data of dataArray) {
            this.addMetricsData(data);
        }
    }
    clearAll() {
        this.data.length = 0;
    }
}
/** @public */
export class PageMetrics extends models.Model {
    constructor() {
        super();
        this.instructions = [];
        this.custom = {};
    }
    addInstruction(instruction) {
        this.instructions.push(instruction);
    }
    addManyInstructions(instructions) {
        for (const instruction of instructions) {
            this.addInstruction(instruction);
        }
    }
    addData(data, invocationPoints) {
        const event = {
            data,
            invocationPoints,
        };
        this.instructions.push(event);
    }
    addManyData(dataArray, invocationPoints) {
        for (const data of dataArray) {
            this.addData(data, invocationPoints);
        }
    }
}
// TODO: This needs to be migrated to the JetEngine version of ImpressionMetrics
// The primary challenge is ID is required in the JetEngine representation, which will require
// some refactoring both in JS and native to get right
/** @public */
export class ImpressionMetrics {
    constructor(fields, id, custom) {
        this.fields = fields;
        this.id = id;
        this.custom = custom;
    }
}
/** @public */
export class FastImpressionMetrics extends ImpressionMetrics {
    constructor(metrics, isFast) {
        super(metrics.fields, metrics.id, metrics.custom || {});
        if (this.custom !== undefined) {
            this.custom["isFast"] = isFast;
        }
        this.isFast = isFast;
    }
}
//# sourceMappingURL=metrics.js.map