import { isSome } from "@jet/environment/types/optional";
import * as models from "./index";
/** @public */
export class HeroCarouselItemOverlay extends models.ViewModel {
    isValid() {
        const hasButtonRequirements = this.callToActionText !== undefined &&
            this.callToActionText !== null &&
            this.clickAction !== undefined &&
            this.clickAction !== null;
        const hasTitle = this.titleText !== undefined && this.titleText !== null;
        const hasLockupRequirements = this.lockup !== undefined && this.lockup !== null;
        const hasCollectionIcons = this.collectionIcons !== undefined && this.collectionIcons !== null;
        return hasTitle && (hasLockupRequirements || hasCollectionIcons || hasButtonRequirements);
    }
}
/** @public */
export class HeroCarouselItem extends models.ViewModel {
    isValid() {
        const hasCollectionIcons = isSome(this.collectionIcons) && this.collectionIcons.length > 0;
        const hasValidArtwork = isSome(this.artwork) && this.artwork.isValid();
        const hasValidVideo = isSome(this.video) && this.video.isValid();
        const hasMedia = hasValidArtwork || hasValidVideo || hasCollectionIcons;
        const hasOverlay = isSome(this.overlay) && this.overlay.isValid();
        return hasMedia && hasOverlay;
    }
}
/** @public */
export class HeroCarousel extends models.ViewModel {
    constructor() {
        super(...arguments);
        /// The different items to display in the carousel
        this.items = [];
        /// The different items to display in the carousel, in RTL
        this.rtlItems = [];
    }
}
//# sourceMappingURL=hero-carousel.js.map