/**
 * Created by km on 2/13/17.
 */
// region Core
/** @public */
export class Model {
    constructor() {
        this.$incidents = undefined;
    }
    /**
     * Indicates whether this model is valid. Subclasses should override if there are specific
     * properties that are required for proper functioning
     * @returns {boolean} Whether the model is valid. Defaults to true.
     */
    isValid() {
        return true;
    }
}
/**
 * @public
 * @todo Make this implement JetEngine ViewModel once we migrate ImpressionMetrics
 */
export class ViewModel extends Model {
    constructor(impressionMetrics = null) {
        super();
        this.impressionMetrics = impressionMetrics;
    }
}
/** @public */
export class PurchaseConfiguration extends Model {
    constructor(buyParams, vendor, appName, bundleId, appPlatforms, isPreorder, excludeAttribution, metricsPlatformDisplayStyle, lineItem, isRedownload, preflightPackageUrl, isArcadeApp, isHalva, supportsVisionOSCompatibleIOSBinary, inAppEventId, extRefApp2, extRefUrl2, additionalHeaders, appCapabilities, isDefaultBrowser, remoteDownloadIdentifiers, hasMacIPAPackage, contentRating) {
        super();
        this.buyParams = buyParams;
        this.vendor = vendor;
        this.appName = appName;
        this.bundleId = bundleId;
        this.appPlatforms = appPlatforms;
        this.isPreorder = isPreorder === null || isPreorder === undefined ? false : isPreorder;
        this.excludeAttribution =
            excludeAttribution === null || excludeAttribution === undefined ? true : excludeAttribution;
        this.metricsPlatformDisplayStyle = metricsPlatformDisplayStyle;
        this.isRedownload = isRedownload === null || isRedownload === undefined ? false : isRedownload;
        this.lineItem = lineItem;
        this.preflightPackageUrl = preflightPackageUrl === undefined ? null : preflightPackageUrl;
        this.isArcadeApp = isArcadeApp;
        this.isHalva = isHalva;
        this.supportsVisionOSCompatibleIOSBinary = supportsVisionOSCompatibleIOSBinary;
        this.inAppEventId = inAppEventId;
        this.extRefApp2 = extRefApp2;
        this.extRefUrl2 = extRefUrl2;
        this.additionalHeaders = additionalHeaders;
        this.appCapabilities = appCapabilities;
        this.isDefaultBrowser = isDefaultBrowser;
        this.remoteDownloadIdentifiers = remoteDownloadIdentifiers;
        this.hasMacIPAPackage = hasMacIPAPackage;
        this.contentRating = contentRating;
    }
}
/** @public */
export class OfferDisplayProperties extends Model {
    constructor(offerType, adamId, bundleId, style, parentAdamId, environment, offerTint, titles, titleSymbolNames, subtitles, hasInAppPurchases, hasExternalPurchases, isDeletableSystemApp, isFree, isPreorder, offerLabelStyle, hasDiscount, contentRating, subscriptionFamilyId, useAdsLocale, priceFormatted, isStreamlinedBuy, appCapabilities, isRedownloadDisallowed = false, isOpenBundleAllowed = false) {
        super();
        this.offerType = offerType;
        this.adamId = adamId;
        this.bundleId = bundleId;
        this.parentAdamId = parentAdamId;
        this.style = style === null || style === undefined ? "infer" : style;
        this.environment = environment === null || environment === undefined ? "light" : environment;
        this.offerTint = offerTint === null || offerTint === undefined ? { type: "blue" } : offerTint;
        this.titles = titles === null || titles === undefined ? {} : titles;
        this.titleSymbolNames = titleSymbolNames === null || titleSymbolNames === undefined ? {} : titleSymbolNames;
        this.subtitles = subtitles === null || subtitles === undefined ? {} : subtitles;
        this.hasInAppPurchases = hasInAppPurchases;
        this.hasExternalPurchases = hasExternalPurchases;
        this.isDeletableSystemApp = isDeletableSystemApp;
        this.isFree = isFree;
        this.isPreorder = isPreorder;
        this.offerLabelStyle = offerLabelStyle === null || offerLabelStyle === undefined ? "none" : offerLabelStyle;
        this.hasDiscount = hasDiscount;
        this.contentRating = contentRating;
        this.subscriptionFamilyId = subscriptionFamilyId;
        this.useAdsLocale = useAdsLocale;
        this.priceFormatted = priceFormatted;
        this.isStreamlinedBuy = isStreamlinedBuy;
        this.appCapabilities = appCapabilities;
        this.isRedownloadDisallowed = isRedownloadDisallowed;
        this.isOpenBundleAllowed = isOpenBundleAllowed;
    }
    /**
     * Create new offer display properties changing appearance.
     * @param {boolean} overrideDisabledStyle When false, an offer style of 'disabled' is maintained. When true, the style is overridden regardless of being disabled to begin with.
     * @param {OfferStyle} style The new style to apply.
     * @param {OfferEnvironment} environment The new environment to apply.
     * @param {OfferTint} offerTint
     * @return {string} A new instance of OfferDisplayProperties with the desired modifications.
     */
    newOfferDisplayPropertiesChangingAppearance(overrideDisabledStyle, style, environment, offerTint) {
        return new OfferDisplayProperties(this.offerType, this.adamId, this.bundleId, style === null || style === undefined || (!overrideDisabledStyle && this.style === "disabled")
            ? this.style
            : style, this.parentAdamId, environment === null || environment === undefined ? this.environment : environment, offerTint === null || offerTint === undefined ? this.offerTint : offerTint, this.titles, this.titleSymbolNames, this.subtitles, this.hasInAppPurchases, this.hasExternalPurchases, this.isDeletableSystemApp, this.isFree, this.isPreorder, this.offerLabelStyle, this.hasDiscount, this.contentRating, this.subscriptionFamilyId, this.useAdsLocale, this.priceFormatted, this.isStreamlinedBuy, this.appCapabilities, this.isRedownloadDisallowed, this.isOpenBundleAllowed);
    }
}
/**
 * @public
 * Information needed to personalize offerActions and how they are displayed.
 */
export class PersonalizedOfferContext extends Model {
    constructor(personalizedOfferType, offerAction, offerDisplayProperties) {
        super();
        this.offerAction = offerAction;
        this.offerDisplayProperties = offerDisplayProperties;
        this.personalizedOfferType = personalizedOfferType;
    }
}
export var ArtworkContentMode;
(function (ArtworkContentMode) {
    ArtworkContentMode[ArtworkContentMode["scaleToFill"] = 0] = "scaleToFill";
    ArtworkContentMode[ArtworkContentMode["scaleAspectFit"] = 1] = "scaleAspectFit";
    ArtworkContentMode[ArtworkContentMode["scaleAspectFill"] = 2] = "scaleAspectFill";
    ArtworkContentMode[ArtworkContentMode["redraw"] = 3] = "redraw";
    ArtworkContentMode[ArtworkContentMode["center"] = 4] = "center";
    ArtworkContentMode[ArtworkContentMode["top"] = 5] = "top";
    ArtworkContentMode[ArtworkContentMode["bottom"] = 6] = "bottom";
    ArtworkContentMode[ArtworkContentMode["left"] = 7] = "left";
    ArtworkContentMode[ArtworkContentMode["right"] = 8] = "right";
    ArtworkContentMode[ArtworkContentMode["topLeft"] = 9] = "topLeft";
    ArtworkContentMode[ArtworkContentMode["topRight"] = 10] = "topRight";
    ArtworkContentMode[ArtworkContentMode["bottomLeft"] = 11] = "bottomLeft";
    ArtworkContentMode[ArtworkContentMode["bottomRight"] = 12] = "bottomRight";
})(ArtworkContentMode || (ArtworkContentMode = {}));
/** @public */
export class ArtworkVariant extends Model {
    constructor(format, quality, supportsWideGamut) {
        super();
        this.format = format;
        this.quality = quality;
        this.supportsWideGamut = supportsWideGamut;
    }
    isValid() {
        return this.format && this.supportsWideGamut !== undefined;
    }
}
const systemImages = [
    "app.3.stack.3d",
    "app.3.stack.3d.fill",
    "applewatch",
    "appstore",
    "hammer",
    "hammer.fill",
    "house",
    "ipad.gen2.landscape",
    "iphone.gen2",
    "joystickcontroller",
    "joystickcontroller.fill",
    "macbook.gen2",
    "magnifyingglass",
    "paintbrush",
    "paintbrush.fill",
    "paperplane",
    "paperplane.fill",
    "person.crop.square",
    "rocket",
    "rocket.fill",
    "safari",
    "square.grid.2x2",
    "square.grid.2x2.fill",
    "star",
    "star.fill",
    "text.rectangle.page",
    "text.rectangle.page.fill",
    "tv",
    "visionpro",
];
/**
 * @public
 * Type guard to narrow and ensure a string is a valid `SystemImage`.
 */
export function isSystemImage(systemImage) {
    return typeof systemImage === "string" && systemImages.includes(systemImage);
}
/** @public */
export class Artwork extends Model {
    constructor(template, width, height, variants, backgroundColor, textColor) {
        super();
        this.checksum = null;
        this.backgroundColor = null;
        this.textColor = null; // Represents a valid text color that can be used alongside this artwork
        this.style = null;
        this.crop = "bb";
        this.contentMode = null;
        this.imageScale = null;
        this.template = template;
        this.width = width;
        this.height = height;
        this.variants = variants;
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
    }
    isPortrait() {
        return this.height >= this.width;
    }
    isLandscape() {
        return !this.isPortrait();
    }
    isValid() {
        return this.template !== "" && this.width > 0 && this.height > 0 && this.variants.length > 0;
    }
}
/** @public */
export class Screenshots extends Model {
    constructor(artwork, mediaPlatform) {
        super();
        this.artwork = artwork;
        this.mediaPlatform = mediaPlatform;
    }
}
/** @public */
export class MediaPlatform extends Model {
    constructor(appPlatform, mediaType, systemImageName, supplementaryAppPlatforms, deviceCornerRadiusFactor, deviceBorderThickness, outerDeviceCornerRadiusFactor) {
        super();
        this.appPlatform = appPlatform;
        this.supplementaryAppPlatforms = supplementaryAppPlatforms || [];
        this.deviceCornerRadiusFactor = deviceCornerRadiusFactor;
        this.mediaType = mediaType;
        this.systemImageName = systemImageName;
        this.deviceBorderThickness = deviceBorderThickness;
        this.outerDeviceCornerRadiusFactor = outerDeviceCornerRadiusFactor;
    }
    isEqualTo(mediaPlatform) {
        this.supplementaryAppPlatforms.sort();
        mediaPlatform.supplementaryAppPlatforms.sort();
        const supplementaryPlatformsAreEqual = this.supplementaryAppPlatforms.join(",") === mediaPlatform.supplementaryAppPlatforms.join(",");
        return (mediaPlatform.appPlatform === this.appPlatform &&
            mediaPlatform.mediaType === this.mediaType &&
            mediaPlatform.systemImageName === this.systemImageName &&
            supplementaryPlatformsAreEqual &&
            mediaPlatform.deviceCornerRadiusFactor === this.deviceCornerRadiusFactor);
    }
}
/**
 * @public
 * Generic size class used to describe an size in points
 */
export class Size {
    constructor(width, height) {
        this.width = width;
        this.height = height;
    }
    static fromNativeSize(nativeSize) {
        return new Size(nativeSize.width, nativeSize.height);
    }
    isEqualTo(size) {
        return size.width === this.width && size.height === this.height;
    }
}
// endregion
// region Share
/** @public */
export class ShareSheetNotesMetadata extends Model {
    constructor(itemName, url, developer, category, fileSize, mediaType) {
        super();
        this.itemName = itemName;
        this.url = url;
        this.developer = developer;
        this.category = category;
        this.fileSize = fileSize;
        this.mediaType = mediaType;
    }
}
/** @public */
export class ShareSheetArticleMetadata extends Model {
    constructor(id, text, subtitle, artwork) {
        super();
        this.context = "article";
        this.id = id;
        this.text = text;
        this.subtitle = subtitle;
        this.artwork = artwork;
    }
}
/** @public */
export class ShareSheetAppEventMetadata extends Model {
    constructor(text, subtitle, artwork) {
        super();
        this.context = "appEvent";
        this.text = text;
        this.subtitle = subtitle;
        this.artwork = artwork;
    }
}
/** @public */
export class ShareSheetProductMetadata extends Model {
    constructor(adamId, storeFrontIdentifier, name, platform, icon, screenshots, videos, isMessagesOnlyApp, subtitle, genreName, messagesAppIcon, notesMetadata) {
        super();
        this.context = "product";
        this.adamId = adamId;
        this.storeFrontIdentifier = storeFrontIdentifier;
        this.name = name;
        this.platform = platform;
        this.icon = icon;
        this.screenshots = screenshots;
        this.videos = videos;
        this.isMessagesOnlyApp = isMessagesOnlyApp;
        this.subtitle = subtitle;
        this.genreName = genreName;
        this.messagesAppIcon = messagesAppIcon;
        this.notesMetadata = notesMetadata;
    }
}
/** @public */
export class ShareSheetGenericMetadata extends Model {
    constructor(text, subtitle, artwork) {
        super();
        this.context = "generic";
        this.text = text;
        this.subtitle = subtitle;
        this.artwork = artwork;
    }
}
/** @public */
export class ShareSheetData extends Model {
    constructor(metadata, url, shortUrl) {
        super();
        this.metadata = metadata;
        this.url = url;
        this.shortUrl = shortUrl;
    }
}
// endregion
// region ReportConcern
/** @public */
export class ReportConcernReason extends Model {
    constructor(reasonId, name, uppercaseName) {
        super();
        this.reasonId = reasonId;
        this.name = name;
        this.uppercaseName = uppercaseName;
    }
}
/** @public */
export class StyledText extends Model {
    constructor(rawText, rawTextType = "text/plain") {
        super();
        this.rawText = rawText;
        this.rawTextType = rawTextType;
    }
}
/** @public */
export class Paragraph extends ViewModel {
    constructor(text, mediaType, style) {
        super();
        this.text = text;
        this.mediaType = mediaType || "text/plain";
        this.style = style || "standard";
        this.alignment = "localized";
        this.isCollapsed = false;
        this.suppressVerticalMargins = false;
        this.wantsCollapsedNewlines = true;
    }
}
// endregion
// region Flow Preview
/** @public */
export class FlowPreviewActionsConfiguration extends Model {
    constructor(actionss, offerDisplayProperties = null, offerActionIndex = null) {
        super();
        this.actions = actionss;
        this.offerDisplayProperties = offerDisplayProperties;
        this.offerActionIndex = offerActionIndex;
    }
}
// region Arcade Footer
/** @public */
export class ArcadeFooter extends ViewModel {
}
// endregion
/** @public
 * Arcade download (starter) pack shelf data model.
 * Currently used only for iPhone (see `ArcadeDownloadPackShelfController`).
 */
export class ArcadeDownloadPackCard extends ViewModel {
}
/** @public */
export class TitleEffect extends Model {
    constructor(type) {
        super();
        this.isFallbackStyle = false;
        this.type = type;
    }
}
// endregion
// region Game Center
/** @public */
export class GameCenterPlayerGameAchievementSummary extends ViewModel {
    constructor(bundleId, completedAchievements, totalAchievements, completedText, action, achievements) {
        super();
        this.bundleId = bundleId;
        this.completedAchievements = completedAchievements;
        this.totalAchievements = totalAchievements;
        this.completedText = completedText;
        this.action = action;
        this.achievements = achievements;
    }
}
/** @public */
export class GameCenterPlayer extends ViewModel {
    constructor(playerId, alias, displayName, size, artwork, action) {
        super();
        this.playerId = playerId;
        this.alias = alias;
        this.displayName = displayName;
        this.artwork = artwork;
        this.action = action;
        this.size = size;
    }
}
/** @public */
export class GameCenterActivityFeedCard extends ViewModel {
    constructor(id, avatarImageURL, avatarActionURL, body, supplementaryViewImageURL, supplementaryViewActionURL, adamID) {
        super();
        this.id = id;
        this.avatarImageURL = avatarImageURL;
        this.avatarActionURL = avatarActionURL;
        this.body = body;
        this.supplementaryViewImageURL = supplementaryViewImageURL;
        this.supplementaryViewActionURL = supplementaryViewActionURL;
        this.adamID = adamID;
    }
}
/** @public */
export class SmallContactCard extends ViewModel {
    constructor(id, title, subtitle, buttonText, contactId, buttonAction, removeButtonAction, shouldShowMessagesBadge) {
        super();
        this.id = id;
        this.title = title;
        this.subtitle = subtitle;
        this.buttonText = buttonText;
        this.contactId = contactId;
        this.buttonAction = buttonAction;
        this.removeButtonAction = removeButtonAction;
        this.shouldShowMessagesBadge = shouldShowMessagesBadge;
    }
}
/** @public */
export class GameCenterAchievementStatus extends Model {
    constructor(type) {
        super();
        this.type = type;
    }
}
/** @public */
export class GameCenterAchievement extends Model {
    constructor(id, title, subtitle, status) {
        super();
        this.id = id;
        this.title = title;
        this.subtitle = subtitle;
        this.status = status;
    }
}
/** @public */
export class GameCenterGameplayHistory extends Model {
    constructor(adamId, platformId, isArcade, records) {
        super();
        this.adamId = adamId;
        this.platformId = platformId;
        this.isArcade = isArcade;
        this.records = records;
    }
}
/** @public */
export class GameCenterGameplayHistoryRecord extends Model {
    constructor(playerId, timestamp) {
        super();
        this.playerId = playerId;
        this.timestamp = timestamp;
    }
}
/** @public */
export class Video extends Model {
    constructor(videoUrl, preview, videoConfiguration) {
        super();
        this.videoUrl = videoUrl;
        this.preview = preview;
        this.allowsAutoPlay = videoConfiguration.allowsAutoPlay;
        this.looping = videoConfiguration.looping;
        this.canPlayFullScreen = videoConfiguration.canPlayFullScreen;
        this.playbackControls = { ...videoConfiguration.playbackControls };
        this.autoPlayPlaybackControls = { ...videoConfiguration.autoPlayPlaybackControls };
        this.templateMediaEvent = null;
    }
}
export class CombinedFileSize {
    constructor(fileSizeByDevice, maxDownloadSizeInBytes, maxInstallSizeInBytes, maxEssentialInstallSizeInBytes) {
        this.fileSizeByDevice = fileSizeByDevice;
        this.maxDownloadSizeInBytes = maxDownloadSizeInBytes;
        this.maxInstallSizeInBytes = maxInstallSizeInBytes;
        this.maxEssentialInstallSizeInBytes = maxEssentialInstallSizeInBytes;
    }
}
/** @public */
export class PageHeader extends ViewModel {
    constructor(badge, title, subtitle) {
        super();
        this.badge = badge;
        this.title = title;
        this.subtitle = subtitle;
    }
}
export class MediaPageHeader extends PageHeader {
    constructor(badge, title, subtitle, artwork, video, collectionIcons, useGeneratedBackgroundGradient, backgroundColor, style, backgroundStyle) {
        super(badge, title, subtitle);
        this.artwork = artwork;
        this.video = video;
        this.collectionIcons = collectionIcons;
        this.useGeneratedBackgroundGradient = useGeneratedBackgroundGradient;
        this.backgroundColor = backgroundColor;
        this.style = style;
        this.backgroundStyle = backgroundStyle;
    }
}
export const EdgeInsetsZero = {
    top: 0.0,
    left: 0.0,
    bottom: 0.0,
    right: 0.0,
};
/**
 * The `Priority` is used when sorting the metrics to match for a given
 * today card, so if we're looking for a layout for a given priority we
 * will match that first
 */
export var TodayCardArtworkSizedLayoutMetricsPriority;
(function (TodayCardArtworkSizedLayoutMetricsPriority) {
    TodayCardArtworkSizedLayoutMetricsPriority["Mini"] = "mini";
    TodayCardArtworkSizedLayoutMetricsPriority["ExtraWide"] = "extraWide";
    TodayCardArtworkSizedLayoutMetricsPriority["None"] = "none";
})(TodayCardArtworkSizedLayoutMetricsPriority || (TodayCardArtworkSizedLayoutMetricsPriority = {}));
export class ChartOrCategorySafeAreaLocation {
}
export var ChartOrCategorySafeAreaRelativeLocation;
(function (ChartOrCategorySafeAreaRelativeLocation) {
    ChartOrCategorySafeAreaRelativeLocation["TopRight"] = "topRight";
    ChartOrCategorySafeAreaRelativeLocation["TopLeft"] = "topLeft";
    ChartOrCategorySafeAreaRelativeLocation["MiddleLeft"] = "middleLeft";
})(ChartOrCategorySafeAreaRelativeLocation || (ChartOrCategorySafeAreaRelativeLocation = {}));
export var ChartOrCategorySafeAreaSizeConstraint;
(function (ChartOrCategorySafeAreaSizeConstraint) {
    ChartOrCategorySafeAreaSizeConstraint["SquareByWidth"] = "squareByWidth";
    ChartOrCategorySafeAreaSizeConstraint["SquareByHeight"] = "squareByHeight";
    ChartOrCategorySafeAreaSizeConstraint["FreeForm"] = "freeForm";
})(ChartOrCategorySafeAreaSizeConstraint || (ChartOrCategorySafeAreaSizeConstraint = {}));
export class ChartOrCategorySafeAreaLocationDistance {
}
export class ChartOrCategorySafeArea {
    constructor(width, height, asRatioOfSize, location, constraint) {
        this.width = width;
        this.height = height;
        this.asRatioOfSize = asRatioOfSize !== null && asRatioOfSize !== void 0 ? asRatioOfSize : false;
        this.location = location;
        this.constraint = constraint;
    }
}
/// The default tile safe area displays the artwork in a square in the top trailing corner of the cell.
ChartOrCategorySafeArea.defaultTileArtworkSafeArea = {
    width: 0.4,
    height: 0.4,
    asRatioOfSize: true,
    constraint: ChartOrCategorySafeAreaSizeConstraint.SquareByWidth,
    location: {
        relativeLocation: ChartOrCategorySafeAreaRelativeLocation.TopRight,
    },
};
/// The default pill safe area displays the artwork on the middle leading side of the cell.
ChartOrCategorySafeArea.defaultPillArtworkSafeArea = {
    width: 0.28,
    height: 1.0,
    asRatioOfSize: true,
    constraint: ChartOrCategorySafeAreaSizeConstraint.FreeForm,
    location: {
        relativeLocation: ChartOrCategorySafeAreaRelativeLocation.MiddleLeft,
    },
};
/// The default tile safe area increases the width available to render the text for the cell.
ChartOrCategorySafeArea.defaultTileTextSafeArea = {
    width: 0.15,
    height: 0.0,
    asRatioOfSize: true,
};
/// The default pill safe area increases the width available to render the text for the cell.
ChartOrCategorySafeArea.defaultPillTextSafeArea = {
    width: 0.28,
    height: 0.0,
    asRatioOfSize: true,
};
//# sourceMappingURL=base.js.map