import * as models from "./index";
import * as metrics from "./metrics/metrics";
export function marketingItemContextFromString(context) {
    var _a, _b;
    if (preprocessor.GAMES_TARGET) {
        switch (context) {
            case "generic":
                return "gameCenterGeneric";
            case "groupingLockup":
                return "gameCenterLockup";
            case "arcadeTabHeader":
                return "gameCenterEditorialPageHeader";
            case "productPage":
                return "gameCenterProductPage";
            case "arcadeComingSoon":
                return "gameCenterComingSoon";
            case "gameCenterEditorialPage": // TBD
                return "gameCenterEditorialPage";
            default:
                return (_a = context) !== null && _a !== void 0 ? _a : "gameCenterGeneric";
        }
    }
    switch (context) {
        case "askToBuy":
            return "arcadeAskToBuy";
        case "generic":
            return "arcadeGeneric";
        case "groupingLockup":
            return "arcadeGroupingLockup";
        case "launchRepair":
            return "arcadeLaunchRepair";
        case "productPage":
            return "arcadeProductPage";
        case "topShelfATV":
            return "arcadeTopShelfATV";
        case "topShelfATVClickThrough":
            return "arcadeTopShelfATVClickThrough";
        case "editorialItem":
            return "arcadeTodayCard";
        case "editorialItemCanvas":
            return "arcadeStoryCanvas";
        case "arcadeComingSoon":
            return "arcadeComingSoon";
        case "arcadeTabHeader":
            return "arcadeTabHeader";
        case "arcadeTabNavBar":
            return "arcadeTabNavBar";
        default:
            return (_b = context) !== null && _b !== void 0 ? _b : "arcadeGeneric";
    }
}
export function isContextualUpsellContext(context) {
    if (preprocessor.GAMES_TARGET) {
        switch (context) {
            case "gameCenterLockup":
            case "gameCenterProductPage":
                return true;
            default:
                return false;
        }
    }
    switch (context) {
        case "arcadeGroupingLockup":
        case "arcadeProductPage":
        case "productPage":
        case "groupingLockup":
            return true;
        default:
            return false;
    }
}
/** @public */
export class ArcadeSubscribePage extends models.Model {
    constructor(details, dismissButtonTitle, offerButtonAction, offerDisplayProperties) {
        super();
        this.details = details;
        this.dismissButtonTitle = dismissButtonTitle;
        this.offerButtonAction = offerButtonAction;
        this.offerDisplayProperties = offerDisplayProperties;
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
/** @public */
export class ArcadeWelcomeItem extends models.Model {
    constructor(headline, body, artwork) {
        super();
        this.headline = headline;
        this.body = body;
        this.artwork = artwork;
    }
}
/** @public */
export class ArcadeWelcomeContent extends models.Model {
    constructor(title, subtitle, items, continueAction, familyAction) {
        super();
        this.title = title;
        this.subtitle = subtitle;
        this.items = items;
        this.continueAction = continueAction;
        this.familyAction = familyAction;
    }
}
/** @public */
export class ArcadeWelcomePage extends models.Model {
    constructor(individualContent, familyMemberContent) {
        super();
        this.individualContent = individualContent;
        this.familyMemberContent = familyMemberContent;
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
/** @public */
export class MarketingItemRequestInfo extends models.Model {
    constructor(serviceType, placement, metricsTopic, seed, clientOptions) {
        super();
        this.serviceType = serviceType;
        this.placement = placement;
        this.seed = seed;
        this.clientOptions = clientOptions;
        this.metricsOverlay = { topic: metricsTopic };
    }
}
/** @public */
export class DynamicUIRequestInfo extends models.Model {
    constructor(metricsTopic, clientOptions) {
        super();
        this.clientOptions = clientOptions;
        this.metricsOverlay = { topic: metricsTopic };
    }
}
/** @public */
export class UpsellGridContent extends models.Model {
    constructor(primaryIcon, icons) {
        super();
        this.primaryIcon = primaryIcon;
        this.icons = icons;
    }
}
/** @public */
export class AppStoreEngagementTask extends models.Model {
    constructor(action) {
        super();
        this.action = action;
    }
}
/** @public
 * A model for game category button on Arcade download pack screen.
 */
export class ArcadeDownloadPackCategory extends models.ViewModel {
    constructor(id, title, artwork, gradientStartColor, gradientEndColor) {
        super();
        this.id = id;
        this.title = title;
        this.artwork = artwork;
        this.gradientStartColor = gradientStartColor;
        this.gradientEndColor = gradientEndColor;
        this.selectActionMetrics = new models.ActionMetrics();
        this.deselectActionMetrics = new models.ActionMetrics();
    }
}
/** @public
 * Initial Arcade download pack screen with game categories to select by user.
 */
export class ArcadeDownloadPackCategoriesPage extends models.Model {
    constructor(title, categories, maxNumberOfCategoriesToChoose, maxNumberOfCategoriesToChooseTemplate, numberOfChosenCategoriesTemplate, primaryAction, dismissAction) {
        super();
        this.title = title;
        this.categories = categories;
        this.maxNumberOfCategoriesToChoose = maxNumberOfCategoriesToChoose;
        this.maxNumberOfCategoriesToChooseTemplate = maxNumberOfCategoriesToChooseTemplate;
        this.numberOfChosenCategoriesTemplate = numberOfChosenCategoriesTemplate;
        this.primaryAction = primaryAction;
        this.dismissAction = dismissAction;
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
/** @public
 * A lockup model for Arcade download suggestions pack screen with linked Arcade category.
 */
export class ArcadeDownloadPackSuggestion extends models.Model {
    constructor(lockup, categoryId) {
        super();
        this.lockup = lockup;
        this.categoryId = categoryId;
    }
}
/** @public
 * Follow up Arcade download pack screen with the list of suggested games.
 */
export class ArcadeDownloadPackSuggestionsPage extends models.Model {
    constructor(title, suggestions, getAllAction, getAllButtonStyle, primaryAction, primaryActionKind, primaryActionSecondaryTitle) {
        super();
        this.title = title;
        this.suggestions = suggestions;
        this.getAllAction = getAllAction;
        this.getAllButtonStyle = getAllButtonStyle;
        this.primaryAction = primaryAction;
        this.primaryActionKind = primaryActionKind;
        this.primaryActionSecondaryTitle = primaryActionSecondaryTitle;
        this.pageMetrics = new metrics.PageMetrics();
        this.pageRenderMetrics = {};
    }
}
/**
 * Matches untyped string with `ArcadeOnboardingSubscriptionStatus` typed value.
 * It is used to convert opaque `string` value that is passed across JS bridge from native code.
 * @param value `string` value with the same content.
 */
export function arcadeOnboardingSubscriptionStatusFromString(value) {
    switch (value) {
        case "new":
            return "new";
        case "existing":
            return "existing";
        default:
            return "unknown";
    }
}
/** @public
 * Purchase params to use in`ASDPurchaseManager.purchaseBatch` call.
 */
export class BatchPurchaseParams {
    constructor(items, commonBuyParams) {
        this.items = items;
        this.commonBuyParams = commonBuyParams;
    }
}
/** @public
 * Decorated purchase for a product with a separate buyParams map.
 */
export class BatchPurchaseItem {
    constructor(purchase, buyParams) {
        this.purchase = purchase;
        this.buyParams = buyParams;
    }
}
//# sourceMappingURL=arcade.js.map