/**
 * Models for Ad Incidents that may occur while building model.
 */
import { Model } from "./base";
/**
 * @public
 * Base Incident Type
 */
export class AdIncident extends Model {
    constructor(incidentType) {
        super();
        this.incidentType = incidentType;
    }
}
/**
 * @public
 * Type of Ad Incident where Ad was discarded due to some reason
 */
export class DiscardAdIncident extends AdIncident {
    constructor(instanceId, reason) {
        super("discard");
        this.instanceId = instanceId;
        this.reason = reason;
    }
}
//# sourceMappingURL=ad-incidents.js.map