import { Action } from "./base-action";
/** @public */
export class FlowBackAction extends Action {
    constructor(dismissal) {
        super("FlowBackAction");
        this.dismissal = dismissal;
    }
}
/** @public */
export class FlowAction extends Action {
    constructor(flowPage, pageUrl) {
        super("FlowAction");
        this.$kind = "flowAction";
        this.page = flowPage;
        this.pageUrl = pageUrl;
        this.pageData = null;
        this.referrerData = undefined;
        this.presentationContext = "infer";
        this.animationBehavior = "infer";
        this.origin = "inapp";
    }
}
export function isFlowAction(action) {
    return action.$kind === "flowAction";
}
//# sourceMappingURL=flow-action.js.map