/**
 * Created by km on 2/13/17.
 */
import { isSome } from "@jet/environment/types/optional";
import * as base from "../base";
import { Action } from "./base-action";
import { ActionMetrics } from "../metrics/metrics";
/** @public */
export class TabChangeAction extends Action {
    constructor(navigationTab) {
        super("TabChangeAction");
        this.navigationTab = navigationTab;
        this.actions = [];
        this.popToRoot = false;
    }
}
/** @public */
export class TabBadgeAction extends Action {
    constructor(navigationTab, text) {
        super("TabBadgeAction");
        this.navigationTab = navigationTab;
        this.text = text;
    }
}
/** @public */
export class ExternalUrlAction extends Action {
    constructor(url, isSensitive = true, actionMetrics = new ActionMetrics()) {
        super("ExternalUrlAction", actionMetrics);
        this.url = url;
        this.isSensitive = isSensitive;
    }
}
/** @public */
export class CompoundAction extends Action {
    constructor(actions) {
        super("CompoundAction");
        const sanitizedActions = [];
        for (const action of actions) {
            if (isSome(action.actionMetrics)) {
                this.actionMetrics.addManyMetricsData(action.actionMetrics.data);
                Object.assign(this.actionMetrics.custom, action.actionMetrics.custom);
                action.actionMetrics.clearAll();
            }
            sanitizedActions.push(action);
        }
        this.actions = sanitizedActions;
    }
}
/** @public */
export class OfferAction extends Action {
    constructor(title, adamId, purchaseConfiguration, parentAdamId) {
        super("OfferAction");
        this.title = title;
        this.adamId = adamId;
        this.parentAdamId = parentAdamId;
        this.purchaseConfiguration = purchaseConfiguration;
        if (purchaseConfiguration) {
            this.bundleId = purchaseConfiguration.bundleId;
            this.lineItem = purchaseConfiguration.lineItem;
        }
        this.includeBetaApps = false;
    }
}
/** @public */
export class OfferConfirmationAction extends Action {
    constructor(buyAction, confirmationInitiationAction) {
        super("OfferConfirmationAction");
        this.buyAction = buyAction;
        this.confirmationInitiationAction = confirmationInitiationAction;
    }
}
/** @public */
export class OfferAlertAction extends Action {
    constructor() {
        super("OfferAlertAction");
        this.title = null;
        this.message = null;
        this.footerMessage = null;
        this.isCancelable = true;
        this.shouldCheckForAvailableDiskSpace = false;
        this.checkRestrictionsForContentRating = null;
        this.remoteControllerRequirement = "NO_BADGE";
        this.spatialControllerRequirement = null;
        this.shouldCheckForGameController = false;
        this.shouldIncludeActiveAccountInFooterMessage = false;
        this.shouldPromptForConfirmation = false;
        this.completionAction = null;
    }
}
/** @public */
export class CancelPreorderAction extends Action {
    constructor(preorderAdamId, isArcade) {
        super("CancelPreorderAction");
        this.preorderAdamId = preorderAdamId;
        this.isArcade = isArcade;
    }
}
/** @public */
export class InAppPurchaseAction extends Action {
    constructor(productIdentifier, appAdamId, appBundleId, installRequiredAction, minimumShortVersionSupportingInAppPurchaseFlow) {
        super("InAppPurchaseAction");
        this.productIdentifier = productIdentifier;
        this.appAdamId = appAdamId;
        this.appBundleId = appBundleId;
        this.installRequiredAction = installRequiredAction;
        this.minimumShortVersionSupportingInAppPurchaseFlow = minimumShortVersionSupportingInAppPurchaseFlow;
    }
}
/** @public */
export class OfferStateAction extends Action {
    constructor(adamId, defaultAction) {
        super("OfferStateAction");
        this.title = defaultAction.title;
        this.adamId = adamId;
        this.defaultAction = defaultAction;
        this.includeBetaApps = false;
    }
}
/** @public */
export class OpenAppAction extends Action {
    constructor(adamId, destination = "app") {
        super("OpenAppAction");
        this.adamId = adamId;
        this.destination = destination;
    }
}
/** @public */
export class OpenGamesUIAction extends Action {
    constructor(target) {
        super("OpenGamesUIAction");
        this.target = target;
    }
}
/** @public
 * Purchase action that contains multiple offers for a set of Arcade games.
 * It is used for "Get all" button in Arcade Download/Starter Pack feature
 * to make a single purchase via App Store Daemon.
 * The action implementation doesn't execute its `offerActions`
 * but uses them as data objects, extracting required parameters.
 * */
export class ArcadePackOfferAction extends Action {
    constructor(offerActions) {
        super("ArcadePackOfferAction");
        this.offerActions = offerActions;
    }
}
/** @public
 * An action representing the "selection" of an app, from the offer button.
 * The intention is to communicate this app was selected to another process, not actually
 * purchase/download/etc.
 * Currently used for the browser selection flow.
 */
export class SelectAppAction extends Action {
    constructor(adamId) {
        super("SelectAppAction");
        this.adamId = adamId;
    }
}
/** @public */
export class HttpAction extends Action {
    constructor(url) {
        super("HttpAction");
        this.url = url;
        this.method = "GET";
        this.headers = {};
        this.body = null;
        this.isStoreRequest = false;
        this.needsAuthentication = false;
        this.needsMediaToken = false;
        this.retryCount = 0;
        this.disableCache = false;
        this.successAction = null;
        this.failureAction = null;
    }
}
/** @public */
export class HttpTemplateParameter {
    constructor(key, target, inputType, title) {
        this.key = key;
        this.target = target;
        this.inputType = inputType;
        this.title = title;
        this.isRequired = true;
        this.maximumLength = null;
    }
}
/** @public */
export class HttpTemplateAction extends Action {
    constructor(url) {
        super("HttpTemplateAction");
        this.message = null;
        this.url = url;
        this.method = "GET";
        this.headers = {};
        this.body = null;
        this.bodyDictionary = {};
        this.parameters = [];
        this.isStoreRequest = false;
        this.needsAuthentication = false;
        this.needsMediaToken = false;
        this.retryCount = 0;
        this.disableCache = false;
        this.successAction = null;
        this.failureAction = null;
    }
}
/** @public */
export class RateAction extends HttpTemplateAction {
}
export class ShowSettingsAction extends Action {
    constructor() {
        super("ShowSettingsAction");
    }
}
/** @public */
export class WriteReviewAction extends Action {
    constructor(adamId, url) {
        super("WriteReviewAction");
        this.adamId = adamId;
        this.url = url;
    }
}
/** @public */
export class PageTabChangeAction extends Action {
    constructor(selectedTabId, title, actionClass) {
        super(actionClass !== null && actionClass !== void 0 ? actionClass : "PageTabChangeAction");
        this.selectedTabId = selectedTabId;
        this.title = title;
    }
}
/** @public */
export class SearchPageSegmentChangeAction extends PageTabChangeAction {
    constructor(selectedTabId, selectedTabTitle, switchToOtherSegmentText) {
        super(selectedTabId, "SearchPageSegmentChangeAction");
        this.switchToOtherSegmentText = switchToOtherSegmentText;
        this.title = selectedTabTitle;
    }
}
/** @public */
export class GameCenterDashboardAction extends Action {
    constructor() {
        super("GameCenterDashboardAction");
    }
}
/** @public */
export class SheetAction extends Action {
    constructor(actions) {
        super("SheetAction");
        this.actions = actions;
        this.isCancelable = false;
        this.cancelTitle = null;
        this.message = null;
        this.style = "default";
        this.isCustom = false;
        this.destructiveActionIndex = null;
    }
}
/** @public */
export class AlertAction extends Action {
    constructor(style) {
        super("AlertAction");
        this.style = style;
        this.title = null;
        this.message = null;
        this.isCancelable = false;
        this.cancelTitle = null;
        this.cancelAction = null;
        this.buttonActions = [];
        this.buttonTitles = [];
        this.destructiveActionIndex = null;
        this.imageName = null;
    }
}
/** @public */
export class ScrollingAlertAction extends Action {
    constructor(title, message) {
        super("ScrollingAlertAction");
        this.title = title;
        this.message = message;
    }
}
/**
 * @public
 * Describes a unique activity as used in a Share Sheet.
 */
export class ShareSheetActivity extends base.ViewModel {
    constructor(activityType, action) {
        super();
        this.activityType = activityType;
        this.action = action;
    }
}
/** @public */
export class ShareSheetAction extends Action {
    constructor(data, activities, style = "expanded") {
        super("ShareSheetAction");
        this.data = data;
        this.activities = activities;
        this.shareSheetStyle = style;
    }
}
/** @public */
export class ReportConcernAction extends Action {
    constructor(reasons) {
        super("ReportConcernAction");
        this.reasons = reasons;
    }
}
/** @public */
export class ReviewSummaryReportConcernAction extends Action {
    constructor(concerns, title, explanation, sendAction) {
        super("ReviewSummaryReportConcernAction");
        this.concerns = concerns;
        this.title = title;
        this.explanation = explanation;
        this.sendAction = sendAction;
    }
}
/** @public */
export class ProductPageScrollAction extends Action {
    constructor(section, clicksOnScroll) {
        super("ProductPageScrollAction");
        this.section = section;
        this.clicksOnScroll = clicksOnScroll;
    }
}
/** @public */
export class ArcadeAction extends Action {
    constructor(productIdentifier, appAdamId, subscriptionToken, postSubscribeAction) {
        super("ArcadeAction");
        this.productIdentifier = productIdentifier;
        this.appAdamId = appAdamId;
        this.postSubscribeAction = postSubscribeAction;
        this.subscriptionToken = subscriptionToken;
    }
}
export class FamilyCircleAction extends Action {
    constructor(clientName, eventType, additionalParameters) {
        super("FamilyCircleAction");
        this.clientName = clientName;
        this.eventType = eventType;
        this.additionalParameters = additionalParameters;
    }
}
/** @public */
export class BlankAction extends Action {
    constructor() {
        super("BlankAction");
    }
}
/** @public */
export class SearchAdAction extends Action {
    constructor(action) {
        super("SearchAdAction");
        this.action = action;
    }
}
/** @public */
export class RateLimitedAction extends Action {
    constructor(actionKey, primaryAction) {
        super("RateLimitedAction");
        this.actionKey = actionKey;
        this.primaryAction = primaryAction;
    }
}
/** @public */
export class ArcadeSubscriptionStateAction extends Action {
    constructor(notSubscribedAction, purchasingAction, subscribedAction, unknownAction) {
        super("ArcadeSubscriptionStateAction");
        this.notSubscribedAction = notSubscribedAction;
        this.purchasingAction = purchasingAction;
        this.subscribedAction = subscribedAction;
        this.unknownAction = unknownAction;
    }
}
/**
 * @public
 * An action for changing the page segment in the Arcade See All Games page.
 */
export class ArcadeSeeAllGamesPageSegmentChangeAction extends Action {
    constructor(facet, selectedOption) {
        super("ArcadeSeeAllGamesPageSegmentChangeAction");
        this.facet = facet;
        this.selectedOption = selectedOption;
    }
}
/** @public */
export class GameCenterPlayerProfileAction extends Action {
    constructor(playerId) {
        super("GameCenterPlayerProfileAction");
        this.playerId = playerId;
    }
}
/** @public */
export class GameCenterAchievementsAction extends Action {
    constructor(bundleId) {
        super("GameCenterAchievementsAction");
        this.bundleId = bundleId;
    }
}
/** @public */
export class LegacyGameCenterInvitePlayerAction extends Action {
    constructor(contactId) {
        super("GameCenterInvitePlayerAction");
        this.contactId = contactId;
    }
}
/** @public */
export class GameCenterInvitePlayerAction extends Action {
    constructor(invitationType) {
        super("GameCenterInvitePlayerAction");
        this.invitationType = invitationType;
    }
}
/** @public */
export class GameCenterDenylistPlayerAction extends Action {
    constructor(contactId) {
        super("GameCenterDenylistPlayerAction");
        this.contactId = contactId;
    }
}
/** @public */
export class PageFacetsChangeAction extends Action {
    constructor(filterParameter) {
        super("PageFacetsChangeAction");
        this.filterParameter = filterParameter;
    }
}
/** @public */
export class EngagementToggleAction extends Action {
    constructor(identifier, value) {
        super("EngagementToggleAction");
        this.identifier = identifier;
        this.value = value;
    }
}
/** @public */
export class ShelfBasedPageScrollAction extends Action {
    constructor(shelfId, notPurchasedShelfId, purchasedShelfId, adamId, index, clicksOnScroll) {
        super("ShelfBasedPageScrollAction");
        this.shelfId = shelfId;
        this.notPurchasedShelfId = notPurchasedShelfId;
        this.purchasedShelfId = purchasedShelfId;
        this.adamId = adamId;
        this.index = index;
        this.clicksOnScroll = clicksOnScroll;
    }
}
/** @public */
export class InvalidateAllWidgetsAction extends Action {
    constructor() {
        super("InvalidateAllWidgetsAction");
    }
}
/** @public */
export class AppLaunchTrampolineAction extends Action {
    constructor(bundleId, payloadUrl, fallbackAction) {
        super("AppLaunchTrampolineAction");
        this.bundleId = bundleId;
        this.payloadUrl = payloadUrl;
        this.fallbackAction = fallbackAction;
    }
}
/** @public */
export class CreateCalendarEventAction extends Action {
    constructor(startDate, endDate, isAllDay, name, location, notes, url, notAuthorizedAction, availability) {
        super("CreateCalendarEventAction");
        this.startDate = startDate;
        this.endDate = endDate;
        this.isAllDay = isAllDay;
        this.name = name;
        this.location = location;
        this.notes = notes;
        this.url = url;
        this.notAuthorizedAction = notAuthorizedAction;
        this.availability = availability;
    }
}
/** @public
 *
 */
export class CopyTextAction extends Action {
    constructor(text) {
        super("CopyTextAction");
        this.text = text;
    }
}
/** @public
 *
 */
export class ClearAppUsageDataAction extends Action {
    constructor() {
        super("ClearAppUsageDataAction");
    }
}
/** @public
 * An action describing a request to delete all recent searches from on-device storage.
 */
export class ClearSearchHistoryAction extends Action {
    constructor() {
        super("ClearSearchHistoryAction");
    }
}
/**
 * @public
 * An action describing an ad interaction, that passes data on to native ad instrumentation
 * via Ad Platforms frameworks.
 */
export class AdInteractionAction extends Action {
    constructor(adActionMetrics) {
        super("AdInteractionAction");
        this.adActionMetrics = adActionMetrics;
    }
}
/**
 * @public
 * An action describes a begin of crossfire referral flow, that will pass the `ReferrerData` on to native to mark the beginning of crossfire flow.
 */
export class CrossfireReferralAction extends Action {
    constructor(referrerData) {
        super("CrossfireReferralAction");
        this.referrerData = referrerData;
    }
}
//# sourceMappingURL=actions.js.map