import { normalizePreviewPlaform } from "../models/preview-platform";
import { normalizeAdamID } from "../util";
export function isGroupingPageIntent(intent) {
    return intent.$kind === "GroupingPageIntent";
}
/**
 * Creates a {@link GroupingPageIntent} "by name"
 *
 * @param options the properties of the created {@link GroupingPageIntent}
 */
export function makeGroupingPageIntentByName(options) {
    const { platform, ...rest } = options;
    return {
        ...rest,
        $kind: "GroupingPageIntent",
        platform: normalizePreviewPlaform(platform),
    };
}
/**
 * Creates a {@link GroupingPageIntent} "by ID"
 *
 * @param options the properties of the created {@link GroupingPageIntent}
 */
export function makeGroupingPageIntentByID(options) {
    const { platform, id, ...rest } = options;
    return {
        ...rest,
        $kind: "GroupingPageIntent",
        id: normalizeAdamID(id),
        platform: normalizePreviewPlaform(platform),
    };
}
//# sourceMappingURL=grouping-page-intent.js.map