const EULA_PAGE_INTENT_KIND = "EulaPageIntent";
/**
 * Determines if {@linkcode intent} is a {@linkcode EulaPageIntent}
 */
export function isEulaPageIntent(intent) {
    return intent.$kind === EULA_PAGE_INTENT_KIND;
}
/**
 * Creates a {@linkcode EulaPageIntent}
 */
export function makeEulaPageIntent({ resourceId, resourceType, ...rest }) {
    return {
        ...rest,
        resourceId,
        resourceType,
        $kind: EULA_PAGE_INTENT_KIND,
    };
}
//# sourceMappingURL=eula-page-intent.js.map