"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeEmptyAction = exports.isEmptyAction = void 0;
/**
 * Custom type guard to determine if an action is an EmptyAction.
 */
function isEmptyAction(action) {
    return (action === null || action === void 0 ? void 0 : action.$kind) === "emptyAction";
}
exports.isEmptyAction = isEmptyAction;
/**
 * Helper that returns an EmptyAction, given an ActionMetrics.
 */
function makeEmptyAction(actionMetrics) {
    return {
        $kind: "emptyAction",
        actionMetrics,
    };
}
exports.makeEmptyAction = makeEmptyAction;
//# sourceMappingURL=empty-action.js.map